<?php
/**
 *	Kalium WordPress Theme
 *
 *	Laborator.co
 *	www.laborator.co
 */
 
// Developer mode ON
if ( ABSPATH == '/Applications/MAMP/htdocs/kalium/wp/' && 'kalium_latest' == DB_NAME ) {
	return;
}

// Hide "Custom Fields" from admin menu
if ( ! get_data( 'kalium_acf_advanced' ) ) {
	define( 'ACF_LITE', true );
}

if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_audio-post-format-settings',
		'title' => 'Audio Post Format Settings',
		'fields' => array (
			array (
				'key' => 'field_5655d3df8c82d',
				'label' => 'Auto Play Audio',
				'name' => 'auto_play_audio',
				'type' => 'true_false',
				'instructions' => 'Play audio immediately when page loads.',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'audio',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-item-type',
		'title' => 'Portfolio Item Type',
		'fields' => array (
			array (
				'key' => 'field_54c7b3e324244',
				'label' => 'Item Type',
				'name' => 'item_type',
				'type' => 'select',
				'instructions' => 'Select one of the portfolio styles.<br />
	<small>Note: If you change the portfolio item type, you must click Update/Publish button in order to view item specific options.</small>',
				'choices' => array (
					'type-1' => 'Side Portfolio',
					'type-2' => 'Columned',
					'type-3' => 'Carousel',
					'type-4' => 'Zig Zag',
					'type-5' => 'Fullscreen',
					'type-6' => 'Lightbox',
					'type-7' => 'Visual Composer',
				),
				'default_value' => 'type-1',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-settings',
		'title' => 'Portfolio Settings',
		'fields' => array (
			array (
				'key' => 'field_54d8ebf646556',
				'label' => 'General Details',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54d8e04115822',
				'label' => 'Show Title & Description',
				'name' => 'show_title_description',
				'type' => 'true_false',
				'message' => '',
				'default_value' => 1,
			),
			array (
				'key' => 'field_54d8d92895f3e',
				'label' => 'Custom Query',
				'name' => 'custom_query',
				'type' => 'true_false',
				'instructions' => 'Manually select portfolio items to show in the list. If none is selected then all portfolio items will be shown. (Optional)',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_54e49cbd3fbd1',
				'label' => 'Masonry Style Portfolio',
				'name' => 'masonry_style_portfolio',
				'type' => 'true_false',
				'instructions' => 'Create custom box sizes for each portfolio item. (Optional)',
				'message' => 'Masonry Mode',
				'default_value' => 0,
			),
			array (
				'key' => 'field_54d8ebd746555',
				'label' => 'Grid Settings',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54d8ec0346557',
				'label' => 'Columns Count',
				'name' => 'columns_count',
				'type' => 'select',
				'instructions' => 'Set portfolio columns count for items.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					1 => '1 Item per Row',
					2 => '2 Items per Row',
					3 => '3 Items per Row',
					4 => '4 Items per Row',
					5 => '5 Items per Row',
					6 => '6 Items per Row',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d91396c63e1',
				'label' => 'Reveal Effect',
				'name' => 'reveal_effect',
				'type' => 'select',
				'instructions' => 'Select effect to apply to thumbnail elements.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'none' => 'None',
					'fade' => 'Fade',
					'slidenfade' => 'Slide and Fade',
					'zoom' => 'Zoom In',
					'fade-one' => 'Fade (one by one)',
					'slidenfade-one' => 'Slide and Fade (one by one)',
					'zoom-one' => 'Zoom In (one by one)',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_572c8fb271fa6',
				'label' => 'Full-width Container',
				'name' => 'portfolio_full_width',
				'type' => 'select',
				'instructions' => 'Extend portfolio container to the browser edge.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_572c900371fa7',
				'label' => 'Title and Filter Container',
				'name' => 'portfolio_full_width_title_container',
				'type' => 'select',
				'instructions' => 'Include title and filter within container.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_572c8fb271fa6',
							'operator' => '==',
							'value' => 'yes',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No (Full-width)',
				),
				'default_value' => 'yes',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db3f22143c1',
				'label' => 'Layout Type',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54db3f3c143c2',
				'label' => 'Layout Type',
				'name' => 'layout_type',
				'type' => 'select',
				'instructions' => 'Select layout type to use for this portfolio page.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'type-1' => 'Thumbnails with Visible Titles',
					'type-2' => 'Thumbnails with Titles Inside',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5530fb8a8c2de',
				'label' => 'Dynamic Image Height',
				'name' => 'portfolio_type_1_dynamic_image_height',
				'type' => 'select',
				'instructions' => 'Use proportional image height for each item.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db52dcf2edb',
				'label' => 'Thumbnail Hover Effect',
				'name' => 'portfolio_type_1_thumbnail_hover_effect',
				'type' => 'select',
				'instructions' => 'Set thumbnail hover effect for this portfolio page.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'none' => 'No hover effect',
					'full' => 'Full background hover',
					'distanced' => 'Distanced background hover',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db53c5e96dc',
				'label' => 'Custom Hover Background Color',
				'name' => 'portfolio_type_1_custom_hover_background_color',
				'type' => 'color_picker',
				'instructions' => 'Apart from defined color styles you can select your own custom color for the hover effect.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-1',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
			),
			array (
				'key' => 'field_54db6aca2befa',
				'label' => 'Dynamic Image Height',
				'name' => 'portfolio_type_2_dynamic_image_height',
				'type' => 'select',
				'instructions' => 'Use proportional image height for each item.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db4b9bc3352',
				'label' => 'Grid Spacing',
				'name' => 'portfolio_type_2_grid_spacing',
				'type' => 'select',
				'instructions' => 'Spacing between portfolio items.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'normal' => 'Default spacing',
					'merged' => 'Merged (no spacing)',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db4dbd94c7d',
				'label' => 'Thumbnail Hover Effect',
				'name' => 'portfolio_type_2_thumbnail_hover_effect',
				'type' => 'select',
				'instructions' => 'Set thumbnail hover effect for this portfolio page.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'none' => 'No hover effect',
					'full' => 'Full background hover',
					'distanced' => 'Distanced background hover',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db9624e3b96',
				'label' => 'Thumbnail Hover Text Position',
				'name' => 'portfolio_type_2_thumbnail_hover_text_position',
				'type' => 'select',
				'instructions' => 'Override text position for hover layer.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'top-left' => 'Top Left',
					'top-right' => 'Top Right',
					'center' => 'Center',
					'bottom-left' => 'Bottom Left',
					'bottom-right' => 'Bottom Right',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db4f000d243',
				'label' => 'Thumbnail Hover Style',
				'name' => 'portfolio_type_2_thumbnail_hover_style',
				'type' => 'select',
				'instructions' => 'Select thumbnail hover background style for this portfolio page.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'primary' => 'Primary theme color',
					'black' => 'Black background',
					'white' => 'White background',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db5045cf3bd',
				'label' => 'Custom Hover Background Color',
				'name' => 'portfolio_type_2_custom_hover_background_color',
				'type' => 'color_picker',
				'instructions' => 'Apart from defined color styles you can select your own custom color for the hover effect.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54db3f3c143c2',
							'operator' => '==',
							'value' => 'type-2',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
			),
			array (
				'key' => 'field_54da0e5ecf168',
				'label' => 'Custom Query',
				'name' => '',
				'type' => 'tab',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
			),
			array (
				'key' => 'field_54d8d99c01093',
				'label' => 'Portfolio Items',
				'name' => 'portfolio_items',
				'type' => 'relationship',
				'instructions' => 'Select portfolio items to include in the query.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'return_format' => 'id',
				'post_type' => array (
					0 => 'portfolio',
				),
				'taxonomy' => array (
					0 => 'all',
				),
				'filters' => array (
					0 => 'search',
				),
				'result_elements' => array (
					0 => 'featured_image',
					1 => 'post_type',
					2 => 'post_title',
				),
				'max' => '',
			),
			array (
				'key' => 'field_54da0a7a88fe9',
				'label' => 'Select From Category',
				'name' => 'select_from_category',
				'type' => 'taxonomy',
				'instructions' => 'Select portfolio items from specific category/categories. Note: This will ignore selected items from above option "Portfolio Items".',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'taxonomy' => 'portfolio_category',
				'field_type' => 'checkbox',
				'allow_null' => 0,
				'load_save_terms' => 0,
				'return_format' => 'id',
				'multiple' => 0,
			),
			array (
				'key' => 'field_5724861a9cc86',
				'label' => 'Select From Tags',
				'name' => 'select_from_tags',
				'type' => 'taxonomy',
				'instructions' => 'Select portfolio items from specific tag/tags. Note: This will ignore selected items from above option "Portfolio Items".',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'taxonomy' => 'portfolio_tag',
				'field_type' => 'checkbox',
				'allow_null' => 0,
				'load_save_terms' => 0,
				'return_format' => 'id',
				'multiple' => 0,
			),
			array (
				'key' => 'field_54da065e1a6ae',
				'label' => 'Order By',
				'name' => 'order_by',
				'type' => 'select',
				'instructions' => 'Set order by field for the selected posts.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'' => 'Default',
					'post__in' => 'List order',
					'date' => 'Date',
					'rand' => 'Random',
					'menu_order' => 'Menu Order',
				),
				'default_value' => 'post__in',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54da072c1a6af',
				'label' => 'Order',
				'name' => 'order',
				'type' => 'select',
				'instructions' => 'Order direction (possible values: Ascending / Descending).',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d8d92895f3e',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'asc' => 'Ascending (ASC)',
					'desc' => 'Descending (DESC)',
				),
				'default_value' => 'asc',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d9f09775823',
				'label' => 'Items per Page',
				'name' => 'items_per_page',
				'type' => 'number',
				'instructions' => 'Set how many portfolio items you want to show per page (leave empty to use WordPress default)',
				'default_value' => '',
				'placeholder' => 'Leave empty to use default WordPress count',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_57275708bea44',
				'label' => 'Number of Items to Fetch',
				'name' => 'endless_per_page',
				'type' => 'text',
				'instructions' => 'Note: Apart from "Items per Page", you can set custom number of items to fetch when "Show More" is clicked. (Optional)<br>
	<small>This option is applied only when "endless pagination" is selected.</small>',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_54e49d5dd71c4',
				'label' => 'Masonry Items',
				'name' => '',
				'type' => 'tab',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54e49cbd3fbd1',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
			),
			array (
				'key' => 'field_54e49d71d71c5',
				'label' => 'How to use it',
				'name' => '',
				'type' => 'message',
				'message' => 'Note: Each portfolio box can have custom size. You must add portfolio items manually one by one. Masonry grid is <strong>12-columns</strong> based so keep in mind to fill the columns properly and not leave gaps.',
			),
			array (
				'key' => 'field_54e49e1dd7d45',
				'label' => 'Portfolio Items',
				'name' => 'masonry_items_list',
				'type' => 'repeater',
				'instructions' => 'Select portfolio items to display. Drag items to change their order in list. Duplicated posts will be removed.',
				'sub_fields' => array (
					array (
						'key' => 'field_54e4aac3ad53d',
						'label' => 'Row of Items',
						'name' => 'items_row',
						'type' => 'repeater',
						'column_width' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54e4ad65ad540',
								'label' => 'Item',
								'name' => 'item',
								'type' => 'post_object',
								'column_width' => '',
								'post_type' => array (
									0 => 'portfolio',
								),
								'taxonomy' => array (
									0 => 'all',
								),
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54e4ad76ad541',
								'label' => 'Box Size',
								'name' => 'box_size',
								'type' => 'select',
								'column_width' => '',
								'choices' => array (
									'12x4' => '12 col - small',
									'12x5' => '12 col - medium',
									'12x6' => '12 col - large',
									'9x3' => '9 col - small',
									'9x4' => '9 col - medium',
									'9x6' => '9 col - large',
									'8x3' => '8 col - small',
									'8x4' => '8 col - medium',
									'8x6' => '8 col - large',
									'6x3' => '6 col - small',
									'6x4' => '6 col - medium',
									'6x6' => '6 col - large',
									'5x3' => '5 col - small',
									'5x4' => '5 col - medium',
									'5x6' => '5 col - large',
									'4x3' => '4 col - small',
									'4x4' => '4 col - medium',
									'4x6' => '4 col - large',
									'3x3' => '3 col - small',
									'3x4' => '3 col - medium',
									'3x6' => '3 col - large',
								),
								'default_value' => '4x3',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
						'row_min' => '',
						'row_limit' => '',
						'layout' => 'table',
						'button_label' => 'Add Item',
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => 'Add Row',
			),
			array (
				'key' => 'field_572750e1c944d',
				'label' => 'Items per Page',
				'name' => 'masonry_items_per_page',
				'type' => 'number',
				'instructions' => 'Set how many portfolio items you want to show per page (by default all masonry items will show)',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_572754d33933b',
				'label' => 'Number of Items to Fetch ',
				'name' => 'masonry_endless_per_page',
				'type' => 'text',
				'instructions' => 'Note: Apart from "Items per Page", you can set custom number of items to fetch when "Show More" is clicked. (Optional)<br>
	<small>This option is applied only when "endless pagination" is selected.</small>',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'page_template',
					'operator' => '==',
					'value' => 'portfolio.php',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_post-slider-images',
		'title' => 'Post Slider Images',
		'fields' => array (
			array (
				'key' => 'field_5502a7cfce21c',
				'label' => 'Post Slider Images',
				'name' => 'post_slider_images',
				'type' => 'gallery',
				'instructions' => 'Add your gallery images here.',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'gallery',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_video-post-format-settings',
		'title' => 'Video Post Format Settings',
		'fields' => array (
			array (
				'key' => 'field_5502ead658c5a',
				'label' => 'Video Resolution',
				'name' => 'video_resolution',
				'type' => 'text',
				'instructions' => 'Set the correct video resolution to make it fit inside the container (avoid black lines). <br />
	You can also set width and height (i.e. 300x240).',
				'default_value' => '16:9',
				'placeholder' => 'Example: 16:9 or 560:315',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_5655d1425a392',
				'label' => 'Auto Play Video',
				'name' => 'auto_play_video',
				'type' => 'true_false',
				'instructions' => 'Play video immediately when page loads.',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
	register_field_group(array (
		'id' => 'acf_side-portfolio-portfolio-type-1',
		'title' => 'Side Portfolio (Portfolio Type 1)',
		'fields' => array (
			array (
				'key' => 'field_54c8cd2c53942',
				'label' => 'Item Description Alignment',
				'name' => 'item_description_alignment',
				'type' => 'select',
				'instructions' => 'Set the alignment of description block that contains item details.',
				'choices' => array (
					'left' => 'Left',
					'right' => 'Right',
				),
				'default_value' => 'left',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54c8cfe8be8a8',
				'label' => 'Item Description Width',
				'name' => 'item_description_width',
				'type' => 'select',
				'instructions' => 'Set the description width (columns) to occupy in item page.',
				'choices' => array (
					'1-4' => 'One fourth (1/4)',
					'1-3' => 'One third (1/3)',
					'1-2' => 'Half width (1/2)',
				),
				'default_value' => '1-3',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54cba2ef32236',
				'label' => 'Gallery Type',
				'name' => 'gallery_type',
				'type' => 'select',
				'instructions' => 'Set placement for gallery images.',
				'choices' => array (
					'inline' => 'Inline with the content',
					'fullbg' => 'Full background',
				),
				'default_value' => 'inline',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d8c4ec258c1',
				'label' => 'Stick Photos to Top',
				'name' => 'gallery_stick_to_top',
				'type' => 'true_false',
				'instructions' => 'Stick gallery photos to the top of page.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54cba2ef32236',
							'operator' => '==',
							'value' => 'fullbg',
						),
					),
					'allorany' => 'all',
				),
				'message' => 'Stick',
				'default_value' => 1,
			),
			array (
				'key' => 'field_54ca5e82cfe95',
				'label' => 'Sticky Description',
				'name' => 'sticky_description',
				'type' => 'true_false',
				'instructions' => 'Make description container sticky when scrolling down the page.',
				'message' => 'Yes',
				'default_value' => 0,
			),
			array (
				'key' => 'field_55785d792a0b4',
				'label' => 'Masonry Mode Gallery',
				'name' => 'masonry_mode_gallery',
				'type' => 'true_false',
				'instructions' => 'Enable this option if you want to use masonry layout for gallery items which helps ordering the images, leaving no extra gaps.',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-1',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 10,
	));
	register_field_group(array (
		'id' => 'acf_columned-portfolio-type-2',
		'title' => 'Columned (Portfolio Type 2)',
		'fields' => array (
			array (
				'key' => 'field_54cf8576bec0d',
				'label' => 'Layout Type',
				'name' => 'layout_type',
				'type' => 'select',
				'instructions' => 'In this portfolio type you can choose between variants of the heading information.',
				'choices' => array (
					'default' => 'Default Layout',
					'centered' => 'Centered Content Layout',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54cfc462777bb',
				'label' => 'Share and Like Position',
				'name' => 'share_and_like_position',
				'type' => 'select',
				'instructions' => 'This is applied only if you have allowed item sharing and portfolio likes.',
				'choices' => array (
					'before' => 'Before gallery',
					'after' => 'After gallery (in the end)',
				),
				'default_value' => 'before',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54cfdbd865d6e',
				'label' => 'Full-width Gallery',
				'name' => 'full_width_gallery',
				'type' => 'true_false',
				'instructions' => 'Shown gallery container in full width size.',
				'message' => 'Yes',
				'default_value' => 0,
			),
			array (
				'key' => 'field_54d0d51d9950d',
				'label' => 'Show Featured Image',
				'name' => 'show_featured_image',
				'type' => 'true_false',
				'instructions' => 'Check this box if you want to show featured image above the post title.',
				'message' => 'Yes',
				'default_value' => 0,
			),
			array (
				'key' => 'field_565eee77b12a7',
				'label' => 'Full-width Featured Image',
				'name' => 'fullwidth_featured_image',
				'type' => 'true_false',
				'instructions' => 'Make this image full width, other elements will not be affected by this option.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d0d51d9950d',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_564d92c32776f',
				'label' => 'Title Position',
				'name' => 'title_position',
				'type' => 'select',
				'instructions' => 'You have chosen to show featured image for this item, this option allows you to set the position of title.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d0d51d9950d',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'before' => 'Before featured image',
					'after' => 'After featured image',
				),
				'default_value' => 'after',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_570f468d87a3b',
				'label' => 'Masonry Mode Gallery',
				'name' => 'masonry_mode_gallery',
				'type' => 'true_false',
				'instructions' => 'Enable this option if you want to use masonry layout for gallery items which helps ordering the images, leaving no extra gaps.',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-2',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 11,
	));
	register_field_group(array (
		'id' => 'acf_carousel-portfolio-type-3',
		'title' => 'Carousel (Portfolio Type 3)',
		'fields' => array (
			array (
				'key' => 'field_54d21cac45fc0',
				'label' => 'Layout Type',
				'name' => 'layout_type',
				'type' => 'select',
				'instructions' => 'In this portfolio type you can choose between variants of the heading information.',
				'choices' => array (
					'default' => 'Default Layout',
					'centered' => 'Centered Content Layout',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-3',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 12,
	));
	register_field_group(array (
		'id' => 'acf_zig-zag-portfolio-type-4',
		'title' => 'Zig Zag (Portfolio Type 4)',
		'fields' => array (
			array (
				'key' => 'field_54d36361b2d95',
				'label' => 'Layout Type',
				'name' => 'layout_type',
				'type' => 'select',
				'instructions' => 'In this portfolio type you can choose between variants of the heading information.',
				'choices' => array (
					'default' => 'Default Layout',
					'centered' => 'Centered Content Layout',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5747fa6857004',
				'label' => 'Share and Like Position',
				'name' => 'share_and_like_position',
				'type' => 'select',
				'instructions' => 'This is applied only if you have allowed item sharing and portfolio likes.',
				'choices' => array (
					'before' => 'Before gallery',
					'after' => 'After gallery (in the end)',
				),
				'default_value' => 'before',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-4',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 13,
	));
	register_field_group(array (
		'id' => 'acf_fullscreen-portfolio-type-5',
		'title' => 'Fullscreen (Portfolio Type 5)',
		'fields' => array (
			array (
				'key' => 'field_54d4e1c18e68b',
				'label' => 'Item Description Visibility',
				'name' => 'item_description_visibility',
				'type' => 'select',
				'instructions' => 'Choose if you want to have description expanded by default or collapsed.',
				'choices' => array (
					'collapsed' => 'Collapsed by default',
					'expanded' => 'Expanded by default',
				),
				'default_value' => 'collapsed',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_55770c3ae6b6e',
				'label' => 'Show Project Info Text',
				'name' => 'show_project_info_text',
				'type' => 'text',
				'instructions' => 'Apart from "Click here to show project info" you can write your own caption.',
				'default_value' => '',
				'placeholder' => 'Click here to show project info',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_55770da7913bd',
				'label' => 'Hide Project Description',
				'name' => 'hide_project_description',
				'type' => 'true_false',
				'instructions' => 'Force hiding the info box in this portfolio item only.',
				'message' => '',
				'default_value' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-5',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 14,
	));
	register_field_group(array (
		'id' => 'acf_lightbox-portfolio-type-6',
		'title' => 'Lightbox (Portfolio Type 6)',
		'fields' => array (
			array (
				'key' => 'field_565b16e5f8220',
				'label' => 'Content to Show',
				'name' => 'content_to_show',
				'type' => 'select',
				'instructions' => 'Select what content type to show in Lightbox when user clicks on thumbnail.',
				'choices' => array (
					'featured-image' => 'Featured Image',
					'other-image' => 'Custom Image',
					'gallery' => 'Multiple Images and/or Video Gallery',
					'self-hosted-video' => 'Self-Hosted Video',
					'youtube' => 'YouTube',
					'vimeo' => 'Vimeo',
				),
				'default_value' => 'featured-image',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_565b1856f8221',
				'label' => 'Custom Image',
				'name' => 'custom_image',
				'type' => 'image',
				'instructions' => 'Select or upload custom image to show for this item.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'other-image',
						),
					),
					'allorany' => 'all',
				),
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_565c8e0b8b789',
				'label' => 'Multiple Images & Video Gallery',
				'name' => 'image_and_video_gallery',
				'type' => 'gallery',
				'instructions' => 'Select images (and/or videos) to attach to this item lightbox.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'gallery',
						),
					),
					'allorany' => 'all',
				),
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_565da645af380',
				'label' => 'Self-Hosted Video',
				'name' => 'self_hosted_video',
				'type' => 'file',
				'instructions' => 'Select video from media gallery. Note: No other file types are supported in this field.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'self-hosted-video',
						),
					),
					'allorany' => 'all',
				),
				'save_format' => 'object',
				'library' => 'all',
			),
			array (
				'key' => 'field_565da8c58f047',
				'label' => 'YouTube Video URL',
				'name' => 'youtube_video_url',
				'type' => 'text',
				'instructions' => 'Enter YouTube video URL.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'youtube',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_565da92b8f048',
				'label' => 'Vimeo Video URL',
				'name' => 'vimeo_video_url',
				'type' => 'text',
				'instructions' => 'Enter Vimeo video URL.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'vimeo',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_565da86d8f044',
				'label' => 'Video Poster',
				'name' => 'video_poster',
				'type' => 'image',
				'instructions' => 'Select image to show as video poster for this video.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'self-hosted-video',
						),
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'vimeo',
						),
						array (
							'field' => 'field_565b16e5f8220',
							'operator' => '==',
							'value' => 'youtube',
						),
					),
					'allorany' => 'any',
				),
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-6',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 15,
	));
	register_field_group(array (
		'id' => 'acf_general-details',
		'title' => 'General Details',
		'fields' => array (
			array (
				'key' => 'field_572dca6076f77',
				'label' => 'Item Details',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54cb9c2d4d383',
				'label' => 'Sub Title',
				'name' => 'sub_title',
				'type' => 'text',
				'instructions' => 'One line title to describe the item (optional).',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_572dca7376f78',
				'label' => 'Prev-Next Navigation',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_572dcd7dca870',
				'label' => 'Custom Prev-Next Links',
				'name' => 'custom_prevnext_links',
				'type' => 'true_false',
				'instructions' => 'Enable custom navigation (prev/next) links for this portfolio item.',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_572dc9d0b7458',
				'label' => 'Previous Item',
				'name' => 'prevnext_previous_id',
				'type' => 'post_object',
				'instructions' => 'Set custom "previous" link for this portfolio item. (Optional)',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_572dcd7dca870',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'post_type' => array (
					0 => 'portfolio',
				),
				'taxonomy' => array (
					0 => 'all',
				),
				'allow_null' => 1,
				'multiple' => 0,
			),
			array (
				'key' => 'field_572dca8576f79',
				'label' => 'Next item',
				'name' => 'prevnext_next_id',
				'type' => 'post_object',
				'instructions' => 'Set custom "next" link for this portfolio item. (Optional)',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_572dcd7dca870',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'post_type' => array (
					0 => 'portfolio',
				),
				'taxonomy' => array (
					0 => 'all',
				),
				'allow_null' => 1,
				'multiple' => 0,
			),
			array (
				'key' => 'field_57b30c9744753',
				'label' => 'Custom Archive URL',
				'name' => 'custom_archive_url',
				'type' => 'text',
				'instructions' => 'Enter custom URL to replace the default portfolio archive URL (Optional)',
				'default_value' => '',
				'placeholder' => 'http://',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 20,
	));
	register_field_group(array (
		'id' => 'acf_project-link',
		'title' => 'Project Link',
		'fields' => array (
			array (
				'key' => 'field_54cb9b638f6c0',
				'label' => 'Launch Link Title',
				'name' => 'launch_link_title',
				'type' => 'text',
				'instructions' => 'Usually written "Launch website"',
				'default_value' => 'Launch website',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_54cb9b9a8f6c1',
				'label' => 'Link URL',
				'name' => 'launch_link_href',
				'type' => 'text',
				'instructions' => 'Website when users click in Launch Link (if not given will not be visible to the user).<br>
	<em>Hint: If you want to disable clicking for this item, just type <strong>#</strong> in this field, and select <strong>Redirect to Link URL (Project URL)</strong> value in <strong>Item Linking</strong>.</em>',
				'default_value' => '',
				'placeholder' => 'http://',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_54cb9bab8f6c2',
				'label' => 'Link Target',
				'name' => 'new_window',
				'type' => 'true_false',
				'instructions' => 'Open in new tab or window when user clicks in link.',
				'message' => 'Open in new window',
				'default_value' => 1,
			),
			array (
				'key' => 'field_55311147850c2',
				'label' => 'Item Linking',
				'name' => 'item_linking',
				'type' => 'select',
				'instructions' => 'Apart from default item single page you can send users to the external source url (optional)',
				'choices' => array (
					'single' => 'Continue on Single Page',
					'external' => 'Redirect to Link URL (Project URL)',
				),
				'default_value' => 'single',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-1',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-2',
					'order_no' => 0,
					'group_no' => 1,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-3',
					'order_no' => 0,
					'group_no' => 2,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-4',
					'order_no' => 0,
					'group_no' => 3,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-5',
					'order_no' => 0,
					'group_no' => 4,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 21,
	));
	register_field_group(array (
		'id' => 'acf_checklists',
		'title' => 'Checklists',
		'fields' => array (
			array (
				'key' => 'field_54cb998106890',
				'label' => 'Checklists',
				'name' => 'checklists',
				'type' => 'repeater',
				'instructions' => 'Add custom checklists for example the services you have finished, tasks done, etc.',
				'sub_fields' => array (
					array (
						'key' => 'field_54cb99aa06891',
						'label' => 'Checklist Title',
						'name' => 'checklist_title',
						'type' => 'text',
						'instructions' => 'Title to describe the checklist items.',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_54cb99b306892',
						'label' => 'Checklist',
						'name' => 'checklist',
						'type' => 'textarea',
						'instructions' => 'Enter one task per line, as many as you want.',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'maxlength' => '',
						'rows' => 5,
						'formatting' => 'html',
					),
					array (
						'key' => 'field_54cb99d606893',
						'label' => 'Column Width',
						'name' => 'column_width',
						'type' => 'select',
						'instructions' => 'Select columns per row for this checklist entry.',
						'column_width' => '',
						'choices' => array (
							'1-1' => 'Full width',
							'1-2' => '50% Column',
						),
						'default_value' => '1-1',
						'allow_null' => 0,
						'multiple' => 0,
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => 'New Checklist',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-1',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-2',
					'order_no' => 0,
					'group_no' => 1,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-3',
					'order_no' => 0,
					'group_no' => 2,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-4',
					'order_no' => 0,
					'group_no' => 3,
				),
			),
			array (
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-5',
					'order_no' => 0,
					'group_no' => 4,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 22,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-gallery',
		'title' => 'Portfolio Gallery',
		'fields' => array (
			array (
				'key' => 'field_54cb8f6397f6f',
				'label' => 'Images Reveal Effect',
				'name' => 'images_reveal_effect',
				'type' => 'select',
				'instructions' => 'Choose the effect to show the item images when they appear in viewport.',
				'choices' => array (
					'none' => 'None',
					'fade' => 'Fade',
					'slidenfade' => 'Slide and Fade',
				),
				'default_value' => 'slidenfade',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54cb8f7d97f70',
				'label' => 'Image Spacing',
				'name' => 'image_spacing',
				'type' => 'select',
				'instructions' => 'You can either set default image spacing or remove it (merge images).',
				'choices' => array (
					'default' => 'Default spacing',
					'nospacing' => 'No spacing (merged)',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5851592e0dd2f',
				'label' => 'Image Captions Position',
				'name' => 'image_captions_position',
				'type' => 'select',
				'instructions' => 'Set image captions position for gallery images.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'hover' => 'On hover',
					'below' => 'Below image',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_57a1e94ec8e20',
				'label' => 'Gallery Columns Gap',
				'name' => 'gallery_columns_gap',
				'type' => 'number',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54cb8f7d97f70',
							'operator' => '==',
							'value' => 'default',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => 'Default columns gap: 30 pixels',
				'prepend' => '',
				'append' => 'px',
				'min' => 0,
				'max' => '',
				'step' => 1,
			),
			array (
				'key' => 'field_54cb8fc197f71',
				'label' => 'Gallery',
				'name' => 'gallery',
				'type' => 'flexible_content',
				'instructions' => 'Select all images you want to show for this portfolio item.',
				'layouts' => array (
					array (
						'label' => 'Image',
						'name' => 'image',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cb900997f72',
								'label' => 'Image',
								'name' => 'image',
								'type' => 'image',
								'instructions' => 'Image that will be shown',
								'column_width' => 60,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cb903397f73',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Images Slider',
						'name' => 'images_slider',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cfacf090383',
								'label' => 'Images',
								'name' => 'images',
								'type' => 'gallery',
								'instructions' => 'Select images to include in the slider',
								'column_width' => '',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cfad5ffe36e',
								'label' => 'Auto Switch',
								'name' => 'auto_switch',
								'type' => 'number',
								'instructions' => 'Set the number of seconds to auto rotate the images',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '0 - By default its disabled',
								'prepend' => '',
								'append' => '',
								'min' => 0,
								'max' => '',
								'step' => 1,
							),
							array (
								'key' => 'field_54cfaccc90382',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Comparison Images',
						'name' => 'comparison_images',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cbad98dfbf1',
								'label' => 'Image 1',
								'name' => 'image_1',
								'type' => 'image',
								'instructions' => 'Assign first image to compare (after)',
								'column_width' => 30,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cbadcddfbf2',
								'label' => 'Image 2',
								'name' => 'image_2',
								'type' => 'image',
								'instructions' => 'Assign second image to compare (before)',
								'column_width' => 30,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cbadf5dfbf3',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'YouTube Video',
						'name' => 'youtube_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccacb63b7a2',
								'label' => 'Video URL',
								'name' => 'video_url',
								'type' => 'text',
								'instructions' => 'Enter YouTube video URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccace109b54',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccae1f11501',
								'label' => 'Video Poster',
								'name' => 'video_poster',
								'type' => 'image',
								'instructions' => 'You can assign video thumbnail (optional)',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_54ccad7e09b55',
											'operator' => '!=',
											'value' => 'default',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_5653182ac91f2',
								'label' => 'Auto Play',
								'name' => 'auto_play',
								'type' => 'true_false',
								'instructions' => 'Start playing video when page loads',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_565319185d634',
								'label' => 'Loop',
								'name' => 'loop',
								'type' => 'true_false',
								'instructions' => 'Restart when video ends',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_5653118216551',
								'label' => 'Default YouTube Player',
								'name' => 'default_youtube_player',
								'type' => 'true_false',
								'instructions' => 'Use YouTube default video player',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_54ccac8c3b7a1',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Vimeo Video',
						'name' => 'vimeo_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccbeeff2d34',
								'label' => 'Video URL',
								'name' => 'video_url',
								'type' => 'text',
								'instructions' => 'Enter Vimeo video URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccbeeff2d35',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccbeeff2d38',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Self-Hosted Video',
						'name' => 'selfhosted_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccc5b6dd8e6',
								'label' => 'Video',
								'name' => 'video_file',
								'type' => 'file',
								'instructions' => 'Upload your own video or select from gallery',
								'column_width' => '',
								'save_format' => 'object',
								'library' => 'all',
							),
							array (
								'key' => 'field_54ccc5b6dd8e7',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccc5b6dd8e9',
								'label' => 'Video Poster',
								'name' => 'video_poster',
								'type' => 'image',
								'instructions' => 'You can assign video thumbnail (optional)',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_54ccad7e09b55',
											'operator' => '!=',
											'value' => 'default',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_56531b176a96d',
								'label' => 'Auto Play',
								'name' => 'auto_play',
								'type' => 'true_false',
								'instructions' => 'Start playing video when page loads',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_56531ba527a4e',
								'label' => 'Loop',
								'name' => 'loop',
								'type' => 'true_false',
								'instructions' => 'Restart when video ends',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_54ccc5b6dd8ea',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Text Quote',
						'name' => 'text_quote',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cfa12b726b2',
								'label' => 'Quote Text',
								'name' => 'quote_text',
								'type' => 'textarea',
								'instructions' => 'Enter the quote text to display in portfolio gallery',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'maxlength' => '',
								'rows' => 5,
								'formatting' => 'br',
							),
							array (
								'key' => 'field_54cfa18bdb105',
								'label' => 'Quote Author',
								'name' => 'quote_author',
								'type' => 'text',
								'instructions' => 'You may or may not include author name for this quote',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54cfa10e726b1',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'HTML',
						'name' => 'html',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_565f2603583c9',
								'label' => 'Content',
								'name' => 'content',
								'type' => 'wysiwyg',
								'instructions' => 'You can also use shortcodes in this field',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'full',
								'media_upload' => 'yes',
							),
							array (
								'key' => 'field_565f2691583cb',
								'label' => 'Column Width',
								'name' => 'column_width',
								'type' => 'select',
								'instructions' => 'Columns for image relative to container',
								'column_width' => '',
								'choices' => array (
									'1-1' => 'Full width (1/1)',
									'1-2' => 'Half width (1/2)',
									'1-3' => 'One third (1/3)',
									'2-3' => 'Two thirds (2/3)',
									'1-4' => 'One fourth (1/4)',
								),
								'default_value' => '1-1',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
				),
				'button_label' => 'Add New',
				'min' => '',
				'max' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-1',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 1,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-2',
					'order_no' => 1,
					'group_no' => 1,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 31,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-gallery-2',
		'title' => 'Portfolio Gallery',
		'fields' => array (
			array (
				'key' => 'field_54d217367778f',
				'label' => 'Images Reveal Effect',
				'name' => 'images_reveal_effect',
				'type' => 'select',
				'instructions' => 'Choose the effect to show the item images when they appear in viewport.',
				'choices' => array (
					'none' => 'None',
					'fade' => 'Fade',
					'slidenfade' => 'Slide and Fade',
				),
				'default_value' => 'slidenfade',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d2542caebc1',
				'label' => 'Image Spacing',
				'name' => 'image_spacing',
				'type' => 'select',
				'instructions' => 'You can either set default image spacing or remove it (merge images).',
				'choices' => array (
					'default' => 'Default spacing',
					'nospacing' => 'No spacing (merged)',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_585162bf9c836',
				'label' => 'Image Captions Position',
				'name' => 'image_captions_position',
				'type' => 'select',
				'instructions' => 'Set image captions position for gallery images.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'hover' => 'On hover',
					'below' => 'Below image',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_57a1ea5e7767d',
				'label' => 'Gallery Columns Gap',
				'name' => 'gallery_columns_gap',
				'type' => 'number',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54d2542caebc1',
							'operator' => '==',
							'value' => 'default',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => 'Default columns gap: 30 pixels',
				'prepend' => '',
				'append' => 'px',
				'min' => 0,
				'max' => '',
				'step' => 1,
			),
			array (
				'key' => 'field_5703cbe608139',
				'label' => 'Maximum Image Height',
				'name' => 'maximum_image_height',
				'type' => 'number',
				'instructions' => '<strong>Optional:</strong> You can set maximum height for images in carousel. Setting value <strong>-1</strong> will show original image height.',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => 'px',
				'min' => '-1',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_5703d1958031a',
				'label' => 'Carousel Start Position',
				'name' => 'carousel_start_position',
				'type' => 'select',
				'instructions' => 'Select starting position of images to show. By default carousel sets image starting position on center.',
				'choices' => array (
					'center' => 'Center',
					'left' => 'Left',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d2123e0e72c',
				'label' => 'Infinite Loop Slides',
				'name' => 'infinite_loop_slides',
				'type' => 'true_false',
				'instructions' => 'Checking this box will make carousel infinite loop when user clicks next/prev buttons.',
				'message' => 'Yes',
				'default_value' => 0,
			),
			array (
				'key' => 'field_54d214c4f5a7f',
				'label' => 'Auto Play',
				'name' => 'auto_play',
				'type' => 'number',
				'instructions' => 'Set number of seconds to automatically change the slides. Leave empty to disable.',
				'default_value' => 7,
				'placeholder' => '',
				'prepend' => 'Seconds:',
				'append' => '',
				'min' => 0,
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_54d0e0254c737',
				'label' => 'Gallery',
				'name' => 'gallery',
				'type' => 'flexible_content',
				'instructions' => 'Select all images you want to show for this portfolio item.',
				'layouts' => array (
					array (
						'label' => 'Image',
						'name' => 'image',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cb900997f72',
								'label' => 'Image',
								'name' => 'image',
								'type' => 'image',
								'instructions' => 'Image that will be shown',
								'column_width' => 60,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54d221bb45227',
								'label' => 'Link URL',
								'name' => 'link_url',
								'type' => 'text',
								'instructions' => 'You may include custom link for this slide (optional)',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => 'http://',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54d221f745228',
								'label' => 'Link Target',
								'name' => 'link_target',
								'type' => 'true_false',
								'instructions' => 'Set the link target when user clicks on it',
								'column_width' => '',
								'message' => 'Open in new window',
								'default_value' => 1,
							),
						),
					),
				),
				'button_label' => 'Add New',
				'min' => '',
				'max' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-3',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 32,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-gallery-3',
		'title' => 'Portfolio Gallery',
		'fields' => array (
			array (
				'key' => 'field_54d35e266493e',
				'label' => 'Images Reveal Effect',
				'name' => 'images_reveal_effect',
				'type' => 'select',
				'instructions' => 'Choose the effect to show the item images when they appear in viewport.',
				'choices' => array (
					'none' => 'None',
					'fade' => 'Fade',
					'slidenfade' => 'Slide and Fade',
				),
				'default_value' => 'slidenfade',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d35e2665363',
				'label' => 'Image Spacing',
				'name' => 'image_spacing',
				'type' => 'select',
				'instructions' => 'You can either set default image spacing or remove it (merge images).',
				'choices' => array (
					'default' => 'Default spacing',
					'nospacing' => 'No spacing (merged)',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_585163afa6780',
				'label' => 'Image Captions Position',
				'name' => 'image_captions_position',
				'type' => 'select',
				'instructions' => 'Set image captions position for gallery images.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'hover' => 'On hover',
					'below' => 'Below image',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54d35e2665d2d',
				'label' => 'Gallery',
				'name' => 'gallery',
				'type' => 'flexible_content',
				'instructions' => 'Select all images you want to show for this portfolio item.',
				'layouts' => array (
					array (
						'label' => 'Image',
						'name' => 'image',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cb900997f72',
								'label' => 'Image',
								'name' => 'image',
								'type' => 'image',
								'instructions' => 'Image that will be shown',
								'column_width' => 60,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54d3607d85ebd',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54cb903397f73',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d35f0ad6bd0',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Images Slider',
						'name' => 'images_slider',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cfacf090383',
								'label' => 'Images',
								'name' => 'images',
								'type' => 'gallery',
								'instructions' => 'Select images to include in the slider',
								'column_width' => '',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cfad5ffe36e',
								'label' => 'Auto Switch',
								'name' => 'auto_switch',
								'type' => 'number',
								'instructions' => 'Set the number of seconds to auto rotate the images',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '0 - By default its disabled',
								'prepend' => '',
								'append' => '',
								'min' => 0,
								'max' => '',
								'step' => 1,
							),
							array (
								'key' => 'field_54d360e8e4ee4',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54d3616349420',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d3623b3782b',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Comparison Images',
						'name' => 'comparison_images',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cbad98dfbf1',
								'label' => 'Image 1',
								'name' => 'image_1',
								'type' => 'image',
								'instructions' => 'Assign first image to compare (after)',
								'column_width' => 30,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54cbadcddfbf2',
								'label' => 'Image 2',
								'name' => 'image_2',
								'type' => 'image',
								'instructions' => 'Assign second image to compare (before)',
								'column_width' => 30,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_54d360f6e4ee5',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54d3617449421',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d362383782a',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'YouTube Video',
						'name' => 'youtube_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccacb63b7a2',
								'label' => 'Video URL',
								'name' => 'video_url',
								'type' => 'text',
								'instructions' => 'Enter YouTube video URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccace109b54',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccae1f11501',
								'label' => 'Video Poster',
								'name' => 'video_poster',
								'type' => 'image',
								'instructions' => 'You can assign video thumbnail (optional)',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_54ccad7e09b55',
											'operator' => '!=',
											'value' => 'default',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_565317d917df0',
								'label' => 'Auto Play',
								'name' => 'auto_play',
								'type' => 'true_false',
								'instructions' => 'Start playing video when page loads',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_5653194f280c4',
								'label' => 'Loop',
								'name' => 'loop',
								'type' => 'true_false',
								'instructions' => 'Restart when video ends',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_5653114034ae3',
								'label' => 'Default YouTube Player',
								'name' => 'default_youtube_player',
								'type' => 'true_false',
								'instructions' => 'Use YouTube default video player',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_54d36104e4ee6',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54d3617849422',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d3623637829',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Vimeo Video',
						'name' => 'vimeo_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccbeeff2d34',
								'label' => 'Video URL',
								'name' => 'video_url',
								'type' => 'text',
								'instructions' => 'Enter Vimeo video URL',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccbeeff2d35',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54d36111e4ee7',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54d3617c49423',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d3623337828',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'Self-Hosted Video',
						'name' => 'selfhosted_video',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54ccc5b6dd8e6',
								'label' => 'Video',
								'name' => 'video_file',
								'type' => 'file',
								'instructions' => 'Upload your own video or select from gallery',
								'column_width' => '',
								'save_format' => 'object',
								'library' => 'all',
							),
							array (
								'key' => 'field_54ccc5b6dd8e7',
								'label' => 'Video Resolution',
								'name' => 'video_resolution',
								'type' => 'text',
								'instructions' => 'Default is used 16:9',
								'column_width' => '',
								'default_value' => '',
								'placeholder' => '16:9 - Enter in this format {number}:{number}',
								'prepend' => '',
								'append' => '',
								'formatting' => 'html',
								'maxlength' => '',
							),
							array (
								'key' => 'field_54ccc5b6dd8e9',
								'label' => 'Video Poster',
								'name' => 'video_poster',
								'type' => 'image',
								'instructions' => 'You can assign video thumbnail (optional)',
								'conditional_logic' => array (
									'status' => 1,
									'rules' => array (
										array (
											'field' => 'field_54ccad7e09b55',
											'operator' => '!=',
											'value' => 'default',
										),
									),
									'allorany' => 'all',
								),
								'column_width' => '',
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
							array (
								'key' => 'field_56531b3d9059a',
								'label' => 'Auto Play',
								'name' => 'auto_play',
								'type' => 'true_false',
								'instructions' => 'Start playing video when page loads',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_56531bc2f506b',
								'label' => 'Loop',
								'name' => 'loop',
								'type' => 'true_false',
								'instructions' => 'Restart when video ends',
								'column_width' => '',
								'message' => '',
								'default_value' => 0,
							),
							array (
								'key' => 'field_54d3611de4ee8',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_54d3618549424',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_54d3623137827',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
					array (
						'label' => 'HTML',
						'name' => 'html',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_565f330be5590',
								'label' => 'Content',
								'name' => 'content',
								'type' => 'wysiwyg',
								'instructions' => 'You can also use shortcodes in this field',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'full',
								'media_upload' => 'yes',
							),
							array (
								'key' => 'field_565f330be5591',
								'label' => 'Description',
								'name' => 'description',
								'type' => 'wysiwyg',
								'instructions' => 'Enter the description for this entry',
								'column_width' => '',
								'default_value' => '',
								'toolbar' => 'basic',
								'media_upload' => 'no',
							),
							array (
								'key' => 'field_565f330be5592',
								'label' => 'Description Width',
								'name' => 'description_width',
								'type' => 'select',
								'instructions' => 'How many columns want to have for the description field',
								'column_width' => '',
								'choices' => array (
									'6-12' => 'Six columns (50%)',
									'5-12' => 'Five columns (40%)',
									'4-12' => 'Four columns (33%)',
								),
								'default_value' => '5-12',
								'allow_null' => 0,
								'multiple' => 0,
							),
							array (
								'key' => 'field_565f330be5593',
								'label' => 'Description Alignment',
								'name' => 'description_alignment',
								'type' => 'select',
								'instructions' => 'Set the alignment for the description text',
								'column_width' => '',
								'choices' => array (
									'left' => 'Left',
									'right' => 'Right',
								),
								'default_value' => 'left',
								'allow_null' => 0,
								'multiple' => 0,
							),
						),
					),
				),
				'button_label' => 'Add New',
				'min' => '',
				'max' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-4',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 33,
	));
	register_field_group(array (
		'id' => 'acf_portfolio-gallery-4',
		'title' => 'Portfolio Gallery',
		'fields' => array (
			array (
				'key' => 'field_54d3abe99ae3e',
				'label' => 'Auto Play',
				'name' => 'auto_play',
				'type' => 'number',
				'instructions' => 'Set number of seconds to automatically change the slides. Leave empty to disable.',
				'default_value' => 7,
				'placeholder' => '',
				'prepend' => 'Seconds:',
				'append' => '',
				'min' => 0,
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_54d3881057933',
				'label' => 'Gallery',
				'name' => 'gallery',
				'type' => 'flexible_content',
				'instructions' => 'Select all images you want to show for this portfolio item.',
				'layouts' => array (
					array (
						'label' => 'Image',
						'name' => 'image',
						'display' => 'row',
						'min' => '',
						'max' => '',
						'sub_fields' => array (
							array (
								'key' => 'field_54cb900997f72',
								'label' => 'Image',
								'name' => 'image',
								'type' => 'image',
								'instructions' => 'Image that will be shown',
								'column_width' => 60,
								'save_format' => 'object',
								'preview_size' => 'thumbnail',
								'library' => 'all',
							),
						),
					),
				),
				'button_label' => 'Add New',
				'min' => '',
				'max' => '',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
				array (
					'param' => 'portfolio_item_type',
					'operator' => '==',
					'value' => 'type-5',
					'order_no' => 1,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 34,
	));
	register_field_group(array (
		'id' => 'acf_other-settings',
		'title' => 'Other Settings',
		'fields' => array (
			array (
				'key' => 'field_54db76b925fcd',
				'label' => 'Custom Hover Background Color',
				'name' => 'custom_hover_background_color',
				'type' => 'color_picker',
				'instructions' => 'You can set custom layer hover color for this portfolio item specifically. (Optional)',
				'default_value' => '',
			),
			array (
				'key' => 'field_54e5e86bfa3e5',
				'label' => 'Hover Effect Style',
				'name' => 'hover_effect_style',
				'type' => 'select',
				'instructions' => 'Set hover effect style for this item only. (Optional)',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'none' => 'No hover effect',
					'full' => 'Full background hover',
					'distanced' => 'Distanced background hover',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db78fc4002d',
				'label' => 'Hover Color Transparency',
				'name' => 'hover_color_transparency',
				'type' => 'select',
				'instructions' => 'Apply custom opacity settings for hover layer on this portfolio item only. (Optional)',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'opacity' => 'Apply Transparency',
					'no-opacity' => 'No Transparency',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54db814e2d5a7',
				'label' => 'Hover Layer Options',
				'name' => 'hover_layer_options',
				'type' => 'select',
				'instructions' => 'Set initial state for hover layer, this setting is applied only for some portfolio types. (Optional)',
				'choices' => array (
					'normal' => 'Normal',
					'none' => 'No hover layer',
					'always-hover' => 'Always show hover layer',
					'hover-reverse' => 'Hide hover layer on hover (reverse state)',
				),
				'default_value' => 'normal',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 40,
	));
	register_field_group(array (
		'id' => 'acf_page-options',
		'title' => 'Page Options',
		'fields' => array (
			array (
				'key' => 'field_54ff2a9a91b27',
				'label' => 'Header Options',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54ff2aa491b28',
				'label' => 'Header Position',
				'name' => 'header_position',
				'type' => 'select',
				'instructions' => 'Set header position (logo and menu).',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'static' => 'Content Below (Static)',
					'absolute' => 'Over the Content (Absolute)',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54ff2fb44fa6c',
				'label' => 'Header Spacing',
				'name' => 'header_spacing',
				'type' => 'number',
				'instructions' => 'If Header Position is set to "Over the Content" this setting will take effect. Unit is Pixels',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54ff2aa491b28',
							'operator' => '==',
							'value' => 'absolute',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => 'px',
				'min' => 0,
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_57308bbb00a7f',
				'label' => 'Full-width Header',
				'name' => 'header_fullwidth',
				'type' => 'select',
				'instructions' => 'Extend header container to the browser edge.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54e6225f20eab',
				'label' => 'Heading Title',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54e6228220eac',
				'label' => 'Heading Title',
				'name' => 'heading_title',
				'type' => 'true_false',
				'instructions' => 'Show or hide page heading title. Note that this setting may not be supported for some pages.',
				'message' => 'Show page heading title',
				'default_value' => 0,
			),
			array (
				'key' => 'field_54e6230120ead',
				'label' => 'Page Title Type',
				'name' => 'page_heading_title_type',
				'type' => 'select',
				'instructions' => 'Use this post title or shown your custom title.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54e6228220eac',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'post_title' => 'Show this post title',
					'custom_title' => 'Enter custom title',
				),
				'default_value' => 'post_title',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54e6235f20eae',
				'label' => 'Page Heading Title',
				'name' => 'page_heading_custom_title',
				'type' => 'text',
				'instructions' => 'Enter your custom page heading title',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54e6230120ead',
							'operator' => '==',
							'value' => 'custom_title',
						),
						array (
							'field' => 'field_54e6228220eac',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'html',
				'maxlength' => '',
			),
			array (
				'key' => 'field_54e623e11c9ee',
				'label' => 'Page Heading Description Type',
				'name' => 'page_heading_description_type',
				'type' => 'select',
				'instructions' => 'Use post content as description or enter custom description.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54e6228220eac',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'post_content' => 'Use this post description',
					'custom' => 'Enter custom description',
				),
				'default_value' => 'custom',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54e624c21c9ef',
				'label' => 'Page Heading Description',
				'name' => 'page_heading_custom_description',
				'type' => 'textarea',
				'instructions' => 'Enter your custom page heading description here. (Optional)',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54e623e11c9ee',
							'operator' => '==',
							'value' => 'custom',
						),
						array (
							'field' => 'field_54e6228220eac',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => 5,
				'formatting' => 'html',
			),
			array (
				'key' => 'field_55b160c4edb8a',
				'label' => 'Logo & Menu',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_55b160d6edb8b',
				'label' => 'Custom Logo',
				'name' => 'custom_logo',
				'type' => 'image',
				'instructions' => 'Use custom logo for this page only.',
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_55b160f3edb8c',
				'label' => 'Custom Logo Width',
				'name' => 'custom_logo_width',
				'type' => 'number',
				'instructions' => 'You can the set maximum width in pixels for the uploaded logo, mostly used when you use upload retina (@2x) logo. (Optional)',
				'default_value' => '',
				'placeholder' => 'Example: 50',
				'prepend' => '',
				'append' => 'px',
				'min' => '',
				'max' => '',
				'step' => '',
			),
			array (
				'key' => 'field_55b163b52c685',
				'label' => 'Custom Menu Skin',
				'name' => 'custom_menu_skin',
				'type' => 'select',
				'instructions' => 'Custom menu skin this page only',
				'choices' => array (
					'default' => 'Use from Theme Options',
					'menu-skin-main' => 'Default (Primary Theme Color)',
					'menu-skin-dark' => 'Black (Dark)',
					'menu-skin-light' => 'White (Light)',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_55b1663309efd',
				'label' => 'Sticky Header',
				'name' => 'sticky_menu_on_page',
				'type' => 'select',
				'instructions' => 'You can enable or disable sticky header on this page only.',
				'choices' => array (
					'default' => 'Use from Theme Options',
					'enable' => 'Enable',
					'disable' => 'Disable',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5836f17c44f7f',
				'label' => 'Custom Sticky Logo',
				'name' => 'custom_sticky_logo',
				'type' => 'image',
				'instructions' => 'Use custom logo for sticky header in this page only.',
				'save_format' => 'id',
				'preview_size' => 'thumbnail',
				'library' => 'all',
			),
			array (
				'key' => 'field_56150e4825cef',
				'label' => 'Sticky Header Skin',
				'name' => 'sticky_menu_skin',
				'type' => 'select',
				'instructions' => 'Set menu skin when sticky header is activated (applied only if sticky menu is enabled)',
				'choices' => array (
					'default' => 'Use from Theme Options',
					'menu-skin-main' => 'Default (Primary Theme Color)',
					'menu-skin-dark' => 'Black (Dark)',
					'menu-skin-light' => 'White (Light)',
				),
				'default_value' => '',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_58382d561e98d',
				'label' => 'Logo Switch',
				'name' => 'section_logo_switch',
				'type' => 'true_false',
				'instructions' => 'Switch header logo and styles on specific sections or sliders.',
				'message' => '',
				'default_value' => 0,
			),
			array (
				'key' => 'field_58382e9f2830e',
				'label' => 'Section Logo Switch',
				'name' => 'logo_switch_sections',
				'type' => 'repeater',
				'instructions' => 'Switch logo and header style on specific sections or slider of page.',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_58382d561e98d',
							'operator' => '==',
							'value' => '1',
						),
					),
					'allorany' => 'all',
				),
				'sub_fields' => array (
					array (
						'key' => 'field_58382f5bd4c4a',
						'label' => 'Switch Type',
						'name' => 'switch_type',
						'type' => 'select',
						'column_width' => '',
						'choices' => array (
							'section' => 'Section',
							'revslider' => 'Revolution Slider',
						),
						'default_value' => 'section',
						'allow_null' => 0,
						'multiple' => 0,
					),
					array (
						'key' => 'field_58382feb87c5a',
						'label' => 'Section ID',
						'name' => 'section_id',
						'type' => 'text',
						'instructions' => 'Target to HTML element',
						'conditional_logic' => array (
							'status' => 1,
							'rules' => array (
								array (
									'field' => 'field_58382f5bd4c4a',
									'operator' => '==',
									'value' => 'section',
								),
							),
							'allorany' => 'all',
						),
						'column_width' => '',
						'default_value' => '',
						'placeholder' => 'my-section-1',
						'prepend' => '#',
						'append' => '',
						'formatting' => 'html',
						'maxlength' => '',
					),
					array (
						'key' => 'field_583832b3d951e',
						'label' => 'Slider',
						'name' => 'revslider',
						'type' => 'revsliders',
						'conditional_logic' => array (
							'status' => 1,
							'rules' => array (
								array (
									'field' => 'field_58382f5bd4c4a',
									'operator' => '==',
									'value' => 'revslider',
								),
							),
							'allorany' => 'all',
						),
						'column_width' => '',
						'default_value' => '',
					),
					array (
						'key' => 'field_583830b862c12',
						'label' => 'Logo',
						'name' => 'logo',
						'type' => 'image',
						'instructions' => 'Upload custom logo for this section/slide',
						'column_width' => '',
						'save_format' => 'object',
						'preview_size' => 'thumbnail',
						'library' => 'all',
					),
					array (
						'key' => 'field_583833540e070',
						'label' => 'Logo Width',
						'name' => 'logo_width',
						'type' => 'number',
						'instructions' => 'Optional',
						'column_width' => '',
						'default_value' => '',
						'placeholder' => '',
						'prepend' => '',
						'append' => '',
						'min' => '',
						'max' => '',
						'step' => '',
					),
					array (
						'key' => 'field_583830f762c13',
						'label' => 'Menu Skin',
						'name' => 'menu_skin',
						'type' => 'select',
						'instructions' => 'Select menu skin for this section/slide',
						'column_width' => '',
						'choices' => array (
							'current' => 'Use current menu skin',
							'menu-skin-main' => 'Default (Primary Theme Color)',
							'menu-skin-dark' => 'Black (Dark)',
							'menu-skin-light' => 'White (Light)',
						),
						'default_value' => 'current',
						'allow_null' => 0,
						'multiple' => 0,
					),
					array (
						'key' => 'field_5838316262c14',
						'label' => 'Transparent',
						'name' => 'transparent_style',
						'type' => 'true_false',
						'instructions' => 'Set transparent header style',
						'column_width' => '',
						'message' => 'Transparent header background, borders and shadow',
						'default_value' => 0,
					),
				),
				'row_min' => '',
				'row_limit' => '',
				'layout' => 'row',
				'button_label' => 'Add Logo Switch Section',
			),
			array (
				'key' => 'field_564dd7b114e58',
				'label' => 'Footer Options',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_564dd7d814e59',
				'label' => 'Footer Visibility',
				'name' => 'footer_visibility',
				'type' => 'select',
				'instructions' => 'Show or hide footer on this specific page.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'show' => 'Show footer on this page',
					'hide' => 'Hide footer on this page',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_564ddabeae7a1',
				'label' => 'Fixed Footer',
				'name' => 'fixed_footer',
				'type' => 'select',
				'instructions' => 'You can overwrite the footer type for this page/post only.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'normal' => 'Normal',
					'fixed' => 'Fixed to Bottom (No animations)',
					'fixed-fade' => 'Fixed to Bottom with Fade Animation',
					'fixed-slide' => 'Fixed to Bottom with Slide Animation',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_5738346a2826f',
				'label' => 'Full-width Footer',
				'name' => 'footer_fullwidth',
				'type' => 'select',
				'instructions' => 'Extend footer container to the browser edge.',
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'yes' => 'Yes',
					'no' => 'No',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 1,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 2,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'product',
					'order_no' => 0,
					'group_no' => 3,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 40,
	));
	register_field_group(array (
		'id' => 'acf_post-settings',
		'title' => 'Post Settings',
		'fields' => array (
			array (
				'key' => 'field_54be705f09c1f',
				'label' => 'Featured Image',
				'name' => '',
				'type' => 'tab',
			),
			array (
				'key' => 'field_54be6ff6e5b9b',
				'label' => 'Featured Image Placing',
				'name' => 'featured_image_placing',
				'type' => 'select',
				'instructions' => 'Select where you want to display the thumbnail (or post content format).',
				'choices' => array (
					'default' => 'Use from Theme Options',
					'container' => 'Within Container',
					'full-width' => 'Full width',
					'hide' => 'Hide Featured Image',
				),
				'default_value' => 'default',
				'allow_null' => 0,
				'multiple' => 0,
			),
			array (
				'key' => 'field_54be714688863',
				'label' => 'Image Size',
				'name' => 'post_image_size',
				'type' => 'select',
				'conditional_logic' => array (
					'status' => 1,
					'rules' => array (
						array (
							'field' => 'field_54be6ff6e5b9b',
							'operator' => '!=',
							'value' => 'hide',
						),
					),
					'allorany' => 'all',
				),
				'choices' => array (
					'inherit' => 'Use from Theme Options',
					'default' => 'Default Thumbnail Size',
					'full' => 'Original Image Size',
				),
				'default_value' => 'inherit',
				'allow_null' => 0,
				'multiple' => 0,
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 50,
	));
	register_field_group(array (
		'id' => 'acf_custom-css',
		'title' => 'Custom CSS',
		'fields' => array (
			array (
				'key' => 'field_567020fe8e640',
				'label' => 'Custom Page Style',
				'name' => 'page_custom_css',
				'type' => 'textarea',
				'instructions' => 'Apply custom CSS only for this page. 
	<br>
	<small>Note: You don\'t need to wrap it with <strong>style</strong> tags (HTML is not allowed in this field).</small>',
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'rows' => 15,
				'formatting' => 'none',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'post',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'page',
					'order_no' => 0,
					'group_no' => 1,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'portfolio',
					'order_no' => 0,
					'group_no' => 2,
				),
			),
			array (
				array (
					'param' => 'post_type',
					'operator' => '==',
					'value' => 'product',
					'order_no' => 0,
					'group_no' => 3,
				),
			),
		),
		'options' => array (
			'position' => 'normal',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 55,
	));
}
