<?php
/**
 *	Kalium WordPress Theme
 *
 *	Laborator.co
 *	www.laborator.co
 */

// Var to tell simple thumbnail if there is actually post format content to be parsed
$blog_post_format_parsed = false;

if ( ! $blog_post_formats ) {
	return;
}
	
	
// Post Format - Image
if ( $post_format == 'image' && $post_image['content'] ) :
	
	$blog_post_format_parsed = true;
	
	$image_size = null;
	$thumb = $post_image['content'];

	if ( $post_thumbnail_id ) {
		$thumb_main = wp_get_attachment_image_src( $post_thumbnail_id, $thumb_size );
		
		if ( is_array( $thumb_main ) ) {
			$thumb = $thumb_main[0];
			$image_size = array( $thumb_main[1], $thumb_main[2] );
		}
	} else {
		// Thumbnail Size
		$thumb_path_native = '';
		$thumb_size_var = 'image_' . md5( $thumb );
		$thumb_size_cached = get_post_meta( $post_id, $thumb_size_var, true );
		
		if ( preg_match( '/' . preg_quote( site_url(), '/' ) . '/', $thumb ) ) {
			$thumb_path_native = str_replace( site_url( '/' ), ABSPATH, $thumb );
		}
		
		$get_image_size = is_array( $thumb_size_cached ) ? $thumb_size_cached : @getimagesize( empty( $thumb_path_native ) ? $thumb : $thumb_path_native );
		
		if ( is_array( $get_image_size ) ) {
			$image_size = array( $get_image_size[0], $get_image_size[1] );
			
			if ( ! $thumb_size_cached ) {
				update_post_meta( $post_id, $thumb_size_var, $image_size );
			}
		}
	}
	
	// Show Aspect Ratio Image
	$thumb_with_placeholder = '';
	
	if ( ! empty( $image_size ) && is_array( $image_size ) ) {	
		ob_start();
		laborator_show_image_placeholder( $thumb, $image_size, '', $blog_post_list_lazy_load );
		$thumb_with_placeholder = ob_get_clean();		
	}
?>
<a href="<?php echo esc_url( $permalink ); ?>" itemprop="image" <?php if ( isset( $image_as ) ) : ?> class="<?php echo $image_as; ?>"<?php endif; ?>>
	
	<?php if ( ! empty( $thumb_with_placeholder ) ) : ?>
		<?php echo $thumb_with_placeholder; ?>
	<?php else : ?>
		<img <?php echo $blog_post_list_lazy_load ? 'data-' : ''; ?>src="<?php echo esc_url( $thumb ); ?>" alt="post-img-<?php echo esc_attr( $post_id ); ?>" />
	<?php endif; ?>
	
	<?php
	if ( ! is_singular() ) {
		include locate_template( 'tpls/post-hover.php' );
	}
	?>
</a>
<?php

endif;
// End of: Post Format - Image

	
// Post Format - Video
if ( $post_format == 'video' && $post_video['content'] ) : 
?>

	<?php if ( isset( $post_video['data']['type'] ) && in_array( $post_video['data']['type'], array( 'native', 'youtube', 'vimeo' ) ) ):
			
			$blog_post_format_parsed = true;
			
			$video_resolution = get_field( 'video_resolution' );
			
			// Custom Aspect Ratio
			if ( preg_match( "/([0-9]+x[0-9]+)|([0-9]+:[0-9]+)/", $video_resolution ) ) {
				$video_resolution = explode( 'x', str_replace( ':', 'x', $video_resolution ) );
				$video_resolution_padding = number_format( $video_resolution[1] / $video_resolution[0] * 100, 8 );
				
				generate_custom_style( ".post-{$post_id} .video-as-holder .video-aspect-ratio", "padding-bottom: {$video_resolution_padding}% !important" );
			}
			
	?>
	<div class="music-video-holder<?php echo " video-type-" . $post_video['data']['type']; ?>">
    	<?php 
	    // Video Object
    	echo $post_video['content']; 
	    ?>
	</div>
	<?php endif; ?>

<?php 
endif;
// End of: Post Format - Video
?>

<?php 
// Post Format - Audio
if ( $post_format == 'audio' && $post_audio['content'] ): 
?>

	<?php
	$blog_post_format_parsed = true;
	
	if ( $post_thumbnail_id ) {
		$img_attachment = wp_get_attachment_image_src( $post_thumbnail_id, $thumb_size );
		
		if ( $img_attachment ) {
			$audio_element_aspect_ratio = laborator_generate_as_element( array( $img_attachment[1], $img_attachment[2] ) );
		}
		
		
	}

	?>
	<div class="music-video-holder video-type-audio <?php echo isset( $audio_element_aspect_ratio ) ? $audio_element_aspect_ratio : ''; ?>">
		<?php echo $post_audio['content']; // Generated by [audio] shortcode ?>
	</div>

<?php 
endif;
// End of: Post Format - Audio


// Post Format - Link
if ( $post_format == 'link' && $post_link['content'] ) :
	
	$blog_post_format_parsed = true;
	
	$permalink = $post_link['content'];
	
	include locate_template( 'tpls/post-thumbnail-simple.php' );
	
	#$permalink = get_permalink();
	
endif;
// End of: Post Format - Link

	
// Post Format - Quote
if ( $post_format == 'quote' && $post_quote['content'] ):
	
	$blog_post_format_parsed = true;
?>
<div class="quote-holder">
	<blockquote><?php
		echo $post_quote['content']; // no escape needed, this is get_the_content()

		if ( isset( $post_quote['data']['cite'] ) )
		{
			echo "<cite>" . $post_quote['data']['cite'] . "</cite>";
		}
	?></blockquote>
</div>
<?php 
endif; 
// End of: Post Format - Quote


// Post Format - Gallery
if ( $post_format == 'gallery' && ( $post_thumbnail_id || count( $slider_images ) ) ) :
	
	$blog_post_format_parsed = true;
	
	?>
	<div class="post-gallery">
	<?php
		$i = 0;
		
		wp_enqueue_script( 'slick' );
		wp_enqueue_style( 'slick' );
		
		if ( $post_thumbnail_id ) {
			$post_attach = get_post( $post_thumbnail_id, $thumb_size );
			
			$link        = is_single() ? $post_attach->guid : $permalink;
			$alt_text    = $post_attach->_wp_attachment_image_alt;
			$is_video    = $alt_text && preg_match( "/(youtube\.com|vimeo\.com)/i", $alt_text );
			$caption     = do_shortcode( $post_attach->post_excerpt );
			
			
			if ( $is_video ) {
				$link = $alt_text;
				$caption = '';
			}
			
			?>
			<a href="<?php echo esc_url( $link ) ; ?>" title="<?php echo esc_attr( $caption ); ?>" data-lightbox-gallery="post-gallery">
				<?php laborator_show_image_placeholder( $post_thumbnail_id, apply_filters( 'kalium_gallery_slider_image_size', $thumb_size ), '', $blog_post_list_lazy_load ); ?>
			</a>
			<?php
			$i++;
		}
		
		if ( is_array( $slider_images ) ) :
		
			foreach ( $slider_images as $image ) :
			
				$link = is_single() ? $image['url'] : $permalink;
				
				$caption = isset( $image['caption'] ) ? $image['caption'] : '';
				$is_video = preg_match( "/(youtube\.com|vimeo\.com)/i", $caption );
				
				if ( $is_video ) {
					$link = $image['caption'];
					$caption = '';
				}
				
				?>
				<a href="<?php echo esc_url( $link ); ?>" title="<?php echo esc_attr( $caption ); ?>" class="<?php when_match( $i > 0, 'hidden' ); ?>"<?php if ( is_single() ): ?> data-lightbox-gallery="post-gallery"<?php endif; ?>>
					<?php echo laborator_show_image_placeholder( $image['id'], apply_filters( 'kalium_gallery_slider_image_size', $thumb_size ), '', $blog_post_list_lazy_load ); ?>
				</a>
				<?php
				
				$i++;
			endforeach;
			
		endif;
	?>
	</div>
	<?php
	
endif;
// End of: Post Format - Link