<?php
/**
 * @package   solo
 * @copyright Copyright (c)2014-2025 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Solo\Model\Json\Task;

use Awf\Container\ContainerAwareInterface;
use Awf\Container\ContainerAwareTrait;
use Solo\Model\Json\TaskInterface;
use Solo\Model\Update;

/**
 * Download the update package
 */
class UpdateDownload implements TaskInterface, ContainerAwareInterface
{
	use ContainerAwareTrait;

	/**
	 * Return the JSON API task's name ("method" name). Remote clients will use it to call us.
	 *
	 * @return  string
	 */
	public function getMethodName()
	{
		return 'updateDownload';
	}

	/**
	 * Execute the JSON API task
	 *
	 * @param   array $parameters The parameters to this task
	 *
	 * @return  mixed
	 *
	 * @throws  \RuntimeException  In case of an error
	 */
	public function execute(array $parameters = array())
	{
		/** @var Update $update */
		$update = $this->getContainer()->mvcFactory->makeTempModel('Update');

		$update->prepareDownload();

		$ret = $update->stepDownload(false);

		if (!$ret['status'])
		{
			throw new \RuntimeException($ret['errorCode'] . ': ' . $ret['error'], 500);
		}

		return true;
	}
}
