<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

// I don't think this is needed any longer? was a test I think...
defined('AKEEBASOLO') || define('AKEEBASOLO', 1);

// Workaround some plugins using wp_die and ACL
defined('DOING_AJAX') || define('DOING_AJAX', 1);

// Workaround some themes using wp_die and ACL
if (! function_exists('houzez_block_users')) {
    function houzez_block_users()
    {
    }
}
/*
 * Fish and Ships – WooCommerce shipping table rate
 * https://wordpress.org/plugins/fish-and-ships/
 * This plugin causes a blank screen of death when init
 */
if (! function_exists('wocommerce_fish_n_ships_init')) {
    function wocommerce_fish_n_ships_init()
    {
    }
}
// More incompatible plugins doing crazy things on init.
if (! function_exists('trx_addons_meta_box_register')) {
    function trx_addons_meta_box_register()
    {
        return true;
    }
}
if (! function_exists('trx_addons_widgets_load')) {
    function trx_addons_widgets_load()
    {
        return true;
    }
}
/*
 * Call to a member function verify_signature() on null
 * wp-content/plugins/oxygen/component-framework/components/component.class.php:3856
 */
if (file_exists('../../oxygen/component-framework/signature.class.php')) {
    global $oxygen_signature;
    require_once '../../oxygen/component-framework/signature.class.php';
}

/*
 * This is a fudge so that plugins that change the wp-admin url that check
 * is_admin() and is_user_logged_in() can pass through our request internally
 * without blocking us. This is not insecure, as we are not actually providing an
 * authenticated user and there is no authentication taking place
 * and wp_get_current_user() would still fail.
 */
if (! function_exists('is_user_logged_in')) {
    function is_user_logged_in()
    {
        return true;
    }
}

// Make sure plugins know we want their admin version
if (! defined('WP_ADMIN')) {
    define('WP_ADMIN', true);
}

// prevent - Undefined offset: 1 in file /var/www/html/wordpress/wp-includes/vars.php line: 32
$_SERVER['PHP_SELF'] = '/wp-admin/index.php';

// Load the WordPress library.
require_once dirname(__FILE__) . '/../../../../wp-load.php';

// For Easy Digital Downloads to use to pretend to add things to the admin page.
require_once ABSPATH . '/wp-admin/includes/admin.php';

// Workaround for some WordPress sites not defining WPINC correctly
if (! defined('WPINC')) {
    define('WPINC', 'wp-includes');
}

/*
 * init admin functions so that some things fire before we do.
 * We need this so that plugins that dont use the default WP way of
 * doing things (Easy Digital Downloads etc) can "do their thing".
 */
do_action('admin_init');
