<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

require 'bfEncrypt.php';

/**
 * If we have got here then we have already passed through decrypting the encrypted header and so we are sure we are now
 * secure and no one else cannot run the code below.
 */

// require all we need to access Joomla API
require 'bfInitWordpress.php';
require 'bfDb.php';
require_once ABSPATH . 'wp-admin/includes/plugin.php';
require_once 'bfActivitylog.php';

final class bfSnapshot
{
    /**
     * @var array
     */
    public $_data;

    /**
     * @var bfDb
     */
    private $db;

    /**
     * @var
     */
    private $version;

    /**
     * @var
     */
    private $config;

    /**
     * @var
     */
    private $wpdb;

    public function __construct()
    {
        // Mysql Table Prefix Global
        global $table_prefix;

        $this->logSnapshot();

        // Our own DB Abstraction Layer
        $this->db = new bfDb();

        /* @noinspection UnusedConstructorDependenciesInspection */
        $this->wpdb = $this->db->getAccess();

        // Use @ to silence crap servers
        $session_save_path     = @ini_get('session_save_path') ? ini_get('session_save_path') : '/tmp';
        $exportRequestsPending = new WP_Query(array(
            'post_type'   => 'user_request',
            'name'        => 'export_personal_data',
            'post_status' => 'request-pending',
            'fields'      => 'ids',
        ));
        $exportRequestsCompleted = new WP_Query(array(
            'post_type'   => 'user_request',
            'name'        => 'export_personal_data',
            'post_status' => 'request-completed',
            'fields'      => 'ids',
        ));
        $removeRequestsPending = new WP_Query(array(
            'post_type'   => 'user_request',
            'name'        => 'remove_personal_data',
            'post_status' => 'request-pending',
            'fields'      => 'ids',
        ));
        $removeRequestsCompleted = new WP_Query(array(
            'post_type'   => 'user_request',
            'name'        => 'remove_personal_data',
            'post_status' => 'request-completed',
            'fields'      => 'ids',
        ));

        // wp_jquerymigrate
        global $wp_scripts;
        if (
            isset($wp_scripts->registered['jquery'])
            && ! empty($wp_scripts->registered['jquery']->deps)
        ) {
            $wp_jquerymigrate = (int) in_array('jquery-migrate', array_values($wp_scripts->registered['jquery']->deps));
        } else {
            $wp_jquerymigrate = 0;
        }

        // The full snapshot data array
        $this->_data = array(
            'version'                     => get_bloginfo('version'),
            'connectorversion'            => file_get_contents('./VERSION'),
            'php_version'                 => \PHP_VERSION,
            'php_disabled_functions'      => ini_get('disable_functions'),
            'display_errors'              => ini_get('display_errors'),
            'register_globals'            => (int) ini_get('register_globals'),
            'safe_mode'                   => (int) ini_get('safe_mode'),
            'file_uploads'                => (int) ini_get('file_uploads'),
            'magic_quotes_gpc'            => (int) ini_get('magic_quotes_gpc'),
            'magic_quotes_runtime'        => (int) ini_get('magic_quotes_runtime'),
            'session_autostart'           => (int) ini_get('session_autostart'),
            'wp_addressequals'            => (int) (get_home_url() === get_site_url()),
            'mysql_version'               => $this->wpdb->db_version(),
            'wp_disabledxmlrpc'           => (bool) 1 - apply_filters('xmlrpc_enabled', true),
            'wp_disabledfileediting'      => defined('DISALLOW_FILE_EDIT') && DISALLOW_FILE_EDIT === true,
            'wp_enabledsearchengine'      => (bool) get_option('blog_public'),
            'wp_taglinechanged'           => 1 - preg_match('/Just\sAnother/im', get_option('blogdescription')),
            'wp_saltchanged'              => (int) $this->checkSalts(),
            'wp_removedsamplepage'        => (int) (($post = get_post(2)) && 'Sample Page'  === $post->post_title) ? 0 : 1,
            'wp_removedhelloworldpost'    => (int) (($post = get_post(1)) && 'Hello world!' === $post->post_title) ? 0 : 1,
            'wp_countinactiveplugins'     => (int) $this->getCountOfDeactivatedPlugins(),
            'wp_defaultcategorychanged'   => ('Uncategorised' !== get_category(
                get_option('default_category')
            )->name && 'Uncategorized' !== get_category(get_option('default_category'))->name) ? 1 : 0,
            'wp_postbyemaildisabled'      => (get_option('mailserver_url') || get_option('mailserver_login') || get_option(
                'mailserver_pass'
            )) ? 0 : 1,
            'wp_trashedcount'             => count(get_posts(array(
                'post_status' => 'trash',
            ))) + count(get_pages(array(
                'post_status' => 'trash',
            ))),
            'wp_draftcount'               => count(get_posts(array(
                'post_status' => 'draft',
            ))) + count(get_pages(array(
                'post_status' => 'draft',
            ))),
            'wp_autosavecount'            => $this->db->loadResult(
                'select count(*) from #__posts where post_type="revision" and post_name LIKE "%-autosave-%"'
            ),
            'wp_revisioncount'            => $this->db->loadResult(
                'select count(*) from #__posts where post_type="revision" and post_name LIKE "%-revision-%"'
            ),
            'wp_globalallowcomments'      => 'open' === get_option('default_comment_status') ? 0 : 1,
            'wp_reqnameoncomment'         => '1'    === get_option('require_name_email') ? 1 : 0,
            'wp_reqloggedin2comment'      => '1'    === get_option('comment_registration') ? 1 : 0,
            'wp_countcommentmoderation'   => count(get_comments(array(
                'status' => 'hold',
            ))),
            'wp_countcommenttrash'        => count(get_comments(array(
                'status' => 'trash',
            ))),
            'userregistrationenabled'     => (int) get_option('users_can_register'),
            'new_usertype'                => 'administrator' === get_option('default_role') ? 8 : 2,
            'numberofsuperadmins'         => count(get_users(array(
                'role' => 'administrator',
            ))),
            'adminusernames'              => count(get_users(array(
                'login' => 'admin',
            ))),
            'pendingprivacyexports'       => count($exportRequestsPending->posts),
            'completedprivacyexports'     => count($exportRequestsCompleted->posts),
            'pendingprivacyremove'        => count($removeRequestsPending->posts),
            'completedprivacyremove'      => count($removeRequestsCompleted->posts),
            'session_save_path'           => $session_save_path,
            'is_windows_host'             => (int) (0 === strpos(\PHP_OS, 'WIN')) ? 1 : 0,
            'session_save_path_writable'  => (int) is_writable($session_save_path),
            'db_prefix'                   => $table_prefix,
            'dbs_visible'                 => $this->getVisibleDbsCount(),
            'db_user_is_root'             => 'root' === DB_USER ? 1 : 0,
            'memory_limit'                => ini_get('memory_limit'),
            'site_debug_enabled'          => (int) defined('WP_DEBUG') && WP_DEBUG === true,
            'defaulttemplateused'         => (int) $this->hasUsedDefaultTemplate(),
            'hasakeebabackup'             => is_plugin_active('akeebabackupwp/akeebabackupwp.php'),
            'adminhtaccess'               => (int) file_exists(ABSPATH . '/wp-admin/.htaccess'),
            'server_hostname'             => function_exists('gethostname') ? gethostname() : php_uname('n'),
            'wp_wpdebuglog'               => (int) defined('WP_DEBUG_LOG')               && WP_DEBUG_LOG               === true,
            'wp_wpdebugdisplay'           => (int) defined('WP_DEBUG_DISPLAY')           && WP_DEBUG_DISPLAY           === true,
            'wp_forcessladmin'            => (int) defined('FORCE_SSL_ADMIN')            && FORCE_SSL_ADMIN            === true,
            'wp_forcessllogin'            => (int) defined('FORCE_SSL_LOGIN')            && FORCE_SSL_LOGIN            === true,
            'wp_wpallowrepair'            => (int) (defined('WP_ALLOW_REPAIR')           && WP_ALLOW_REPAIR            === true),
            'wp_disallowunfilteredhtml'   => (int) defined('DISALLOW_UNFILTERED_HTML')   && DISALLOW_UNFILTERED_HTML   === true,
            'wp_allowunfiltereduploads'   => (int) defined('ALLOW_UNFILTERED_UPLOADS')   && ALLOW_UNFILTERED_UPLOADS   === false,
            'wp_automaticupdaterdisabled' => (int) defined('AUTOMATIC_UPDATER_DISABLED') && AUTOMATIC_UPDATER_DISABLED === true,
            'wp_wpautoupdatecore'         => (int) defined('WP_AUTO_UPDATE_CORE')        && WP_AUTO_UPDATE_CORE        === 'minor',
            'wp_disallowfilemods'         => (int) defined('DISALLOW_FILE_MODS')         && DISALLOW_FILE_MODS         === true,
            'wp_scriptdebug'              => (int) defined('SCRIPT_DEBUG')               && SCRIPT_DEBUG               === false,
            'wp_postrevisionsdefine'      => (int) defined('WP_POST_REVISIONS')          && WP_POST_REVISIONS          === '10',
            'wp_autosaveinterval'         => (int) defined('AUTOSAVE_INTERVAL')          && AUTOSAVE_INTERVAL          === '30',
            'wp_savequeries'              => 1 - (defined('SAVEQUERIES')                 && SAVEQUERIES                === true),
            'wp_debuglogpresent'          => (int) file_exists(ABSPATH . '/wp-content/debug.log'),
            'wp_blogname'                 => get_bloginfo('name'),
            'wp_emojis'                   => has_action('wp_head', 'print_emoji_detection_script') ? 1 : 0,
            'wp_jquerymigrate'            => $wp_jquerymigrate,
            'wp_adminfooter'              => 1 - (int) has_action('admin_footer_text'),
            'wp_generator'                => has_action('wp_head', 'wp_generator') ? 1 : 0,
            'wp_shortlink'                => has_action('wp_head', 'wp_shortlink_wp_head') ? 1 : 0,
            'wp_adminbarwp'               => 1 - (int) defined('mysites_remove_adminbar_wp'),
            'wp_apppwavailable'           => (int) function_exists(
                'wp_is_application_passwords_available'
            ) ? wp_is_application_passwords_available() : 0,
            'wp_disablecommlinks'         => 1 - (int) defined('mysites_disable_comment_links'),
            'wp_howdy'                    => (int) defined('mysites_disable_howdy'),
            'wp_nags'                     => (int) defined('mysites_disable_nags'),
            'wp_frontbar'                 => (int) defined('mysites_frontendmenubar'),
        );

        $this->cleanOurCrap();
    }

    private function logSnapshot()
    {
        bfActivitylog::getInstance()->log(
            'bfNetwork',
            '',
            'Snapshot Taken',
            'onSnapshotTaken',
            'bfNetwork',
            null,
            null,
            '',
            bfEvents::onSnapshotTaken,
            'onSnapshotTaken',
            bfEvents::onSnapshotTaken
        );
    }

    /**
     * @return int
     */
    private function checkSalts()
    {
        if (
            AUTH_KEY === 'put your unique phrase here' ||
            SECURE_AUTH_KEY === 'put your unique phrase here' ||
            LOGGED_IN_KEY === 'put your unique phrase here' ||
            NONCE_KEY === 'put your unique phrase here' ||
            AUTH_SALT === 'put your unique phrase here' ||
            SECURE_AUTH_SALT === 'put your unique phrase here' ||
            LOGGED_IN_SALT === 'put your unique phrase here' ||
            NONCE_SALT === 'put your unique phrase here'
        ) {
            $usingDefault = 0;
        } else {
            $usingDefault = 1;
        }

        return $usingDefault;
    }

    /**
     * Get the number of plugins that are inactive/disabled and need deleting.
     *
     * @return int
     */
    private function getCountOfDeactivatedPlugins()
    {
        $disabled = 0;
        foreach (get_plugins() as $plug => $plugin) {
            $disabled += (int) is_plugin_inactive($plug);
        }

        return $disabled;
    }

    /**
     * How many databases can I see?
     *
     * We need to reconnect again to the db so we are ot going through the Joomla DB Layer because it just crashes too
     * far up the stack for us to catch the exception
     *
     * @return int
     */
    private function getVisibleDbsCount()
    {
        try {
            $this->db->setQuery(
                'SHOW DATABASES  where `Database` NOT IN ("sys", "test", "information_schema","performance_schema", "mysql")'
            );
            // return number seen
            return count($this->db->loadObjectList());
        } catch (Exception $e) {
            bfLog::log(__FUNCTION__ . ':' . $e->getMessage());

            return 0;
        }
    }

    /**
     * @return bool
     */
    private function hasUsedDefaultTemplate()
    {
        $coreTemplates = array('twentyfifteen', 'twentysixteen', 'twentyseventeen', 'twentyeighteen', 'twentynighteen');

        return (bool) (in_array(wp_get_theme()->get_template(), $coreTemplates)) ? 1 : 0;
    }

    /**
     * @return array
     */
    public function getData()
    {
        return $this->_data;
    }

    /**
     * Clean up old mysites.guru files and features.
     */
    private function cleanOurCrap()
    {
        // cleanup old files
        $oldFiles = array(
            'upgrade.zip',
            './bfViewLog.php',
            './bfDev.php',
            './bfMysql.php',
            './j25_30_bfnetwork.xml', // dont get confused with the one in the folder above this.
            './install.bfnetwork.php',
            './bfnetwork.xml',
            './bfJson.php',
            './tmp/log.tmp',
            './tmp/tmp.ob',
        );

        foreach ($oldFiles as $file) {
            if (file_exists($file)) {
                @unlink($file);
            }
        }

        bfActivitylog::getInstance();
    }
}
$data = new bfSnapshot();
bfEncrypt::reply(bfReply::SUCCESS, $data->getData());
