<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

/**
 * If we have got here then we have already passed through decrypting the encrypted header and so we are sure we are now
 * secure and no one else cannot run the code below.
 */
final class bfUpdates
{
    /**
     * @param bool $returnCount
     *
     * @return bool|int|array
     */
    public function getUpdates($returnCount = false)
    {
        require_once ABSPATH . '/wp-admin/includes/plugin-install.php';
        require_once ABSPATH . '/wp-admin/includes/update.php';
        require_once ABSPATH . '/wp-admin/includes/plugin.php';

        // Plugins
        wp_clean_update_cache();
        wp_clean_plugins_cache();
        wp_clean_themes_cache();
        wp_update_plugins();
        wp_update_themes();

        // Core
        wp_version_check(array(), true);
        get_core_updates();

        $updatesAvailable = array();

        // for all installed items...
        foreach (get_plugin_updates() as $item) {
            $i                    = new stdClass();
            $i->name              = $item->Name;
            $i->type              = 'plugins';
            $i->current_version   = $item->update->new_version;
            $i->infourl           = $item->update->url;
            $i->update            = $item->update;
            $i->installed_version = $item->Version;

            if (property_exists($item->update, 'id')) {
                $i->eid = $item->update->id;
            }

            // inject to our array we will return
            $updatesAvailable[] = $i;
        }

        foreach (get_theme_updates() as $item) {
            $i                    = new stdClass();
            $i->name              = $item->Name;
            $i->type              = 'themes';
            $i->current_version   = $item->update['new_version'];
            $i->infourl           = $item->update['url'];
            $i->installed_version = $item->Version;
            $i->eid               = $item->update['theme'];

            $updatesAvailable[] = $i;
        }

        // if we are in bfAuditor then we want just a count of the items or the actual items?
        if (false === $returnCount) {
            $data            = array();
            $data['updates'] = $updatesAvailable;
            $data['sites']   = json_encode(array()); // @todo

            return $data;
        }

        return count($updatesAvailable);
    }
}
