DROP TABLE IF EXISTS `bf_core_hashes`;
DROP TABLE IF EXISTS `bf_folders_to_scan`;
DROP TABLE IF EXISTS `bf_files`;
DROP TABLE IF EXISTS `bf_folders`;
DROP TABLE IF EXISTS `bf_scan_state`;

CREATE TABLE `bf_core_hashes`
(
    `id`           int(11)                       NOT NULL AUTO_INCREMENT,
    `filewithpath` mediumtext CHARACTER SET utf8 NOT NULL,
    `hash`         varchar(32) CHARACTER SET utf8 DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `filewithpath` (`filewithpath`(191)),
    KEY `hash` (`hash`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_folders_to_scan`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `folderwithpath` text CHARACTER SET utf8mb4 DEFAULT NULL,
    PRIMARY KEY (`id`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_files`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `filewithpath`   text CHARACTER SET utf8         DEFAULT NULL,
    `fileperms`      varchar(255) CHARACTER SET utf8 DEFAULT NULL,
    `filemtime`      varchar(255) CHARACTER SET utf8 DEFAULT NULL,
    `toggler`        int(11)                         DEFAULT NULL,
    `currenthash`    varchar(32) CHARACTER SET utf8  DEFAULT NULL,
    `lasthash`       varchar(255) CHARACTER SET utf8 DEFAULT NULL,
    `iscorefile`     int(11)                         DEFAULT NULL,
    `hashfailed`     int(1)                          DEFAULT NULL,
    `hashchanged`    int(1)                          DEFAULT NULL,
    `hacked`         int(1)                          DEFAULT NULL,
    `skipped`        int(1)                          DEFAULT NULL,
    `suspectcontent` int(1)                          DEFAULT NULL,
    `falsepositive`  int(1)                          DEFAULT NULL,
    `mailer`         int(1)                          DEFAULT NULL,
    `uploader`       int(1)                          DEFAULT NULL,
    `encrypted`      int(1)                          DEFAULT NULL,
    `queued`         int(11)                         DEFAULT NULL,
    `size`           int(11)                         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `currenthash` (`currenthash`),
    KEY `iscorefile` (`iscorefile`),
    KEY `filewithpath` (`filewithpath`(191)),
    KEY `size` (`size`),
    KEY `hashfailed` (`hashfailed`),
    KEY `size_2` (`size`, `hashfailed`, `filewithpath`(191), `iscorefile`, `currenthash`),
    KEY `encrypted` (`encrypted`),
    KEY `queued` (`queued`),
    KEY `mailer` (`mailer`),
    KEY `uploader` (`uploader`),
    KEY `hacked` (`hacked`),
    KEY `skipped` (`skipped`),
    KEY `suspectcontent` (`suspectcontent`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;

CREATE TABLE `bf_folders`
(
    `id`             int(11) NOT NULL AUTO_INCREMENT,
    `folderwithpath` text CHARACTER SET utf8         DEFAULT NULL,
    `folderinfo`     varchar(255) CHARACTER SET utf8 DEFAULT NULL,
    `foldermtime`    varchar(255) CHARACTER SET utf8 DEFAULT NULL,
    `filesinfolder`  int(11)                         DEFAULT NULL,
    `queued`         int(11)                         DEFAULT NULL,
    PRIMARY KEY (`id`),
    KEY `folderwithpath` (`folderwithpath`(191)),
    KEY `folderinfo` (`folderinfo`),
    KEY `foldermtime` (`foldermtime`),
    KEY `queued` (`queued`),
    KEY `filesinfolder` (`filesinfolder`)
) ENGINE = InnoDB
  DEFAULT CHARSET = utf8mb4
  COLLATE = utf8mb4_bin;
