<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

use ProteusThemes\ThemeRegistration\ThemeRegistration;

/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

define('mysites_disable_nags', 1);

function mysites_nag_remove()
{
    echo '<style>
            #welcome-panel,
            #rsssl-message,
            .update-nag,
            .updated,
            .notice,
            .tiny-notice,
            .error,
            .is-dismissible,
            .notice-error,
            .eg-update-notice-wrap,
            .otgs-is-dismissible,
            .elementor-message,
            .trp-notice,
            .rml-update-notice,
            .updated .envira-notice,
            .yellowpencil-notice,
            .modula-notice,
            .error-is-dismissible
            {
                display: none !important;
            }
            </style>

            <script type="text/javascript">
                function mySites_docReady(fn) {
                    if (document.readyState === "complete" || document.readyState === "interactive") {
                        setTimeout(fn, 1);
                    } else {
                        document.addEventListener("DOMContentLoaded", fn);
                    }
                }
                function mySites_removeElementsByClass(className){
                    const elements = document.getElementsByClassName(className);
                    while(elements.length > 0){
                        elements[0].parentNode.removeChild(elements[0]);
                    }
                }    
                mySites_docReady(function() {
                    mySites_removeElementsByClass("update-nag");
                });
                </script>';
}

remove_action('admin_notices', 'update_nag', 3);
remove_action('admin_notices', 'maintenance_nag', 10);
add_action('admin_enqueue_scripts', 'mysites_nag_remove');
add_action('login_enqueue_scripts', 'mysites_nag_remove');
add_filter('jetpack_just_in_time_msgs', '__return_false');
remove_action('wpcf7_admin_warnings', 'wpcf7_notice_bulk_validate_config');

add_action('after_setup_theme', function () {
    if (class_exists('\ProteusThemes\ThemeRegistration\ThemeRegistration')) {
        remove_action('admin_notices', array(ThemeRegistration::get_instance(), 'purchase_code_has_expired_admin_notice'));
    }
});

add_filter('woocommerce_helper_suppress_admin_notices', '__return_true');
add_filter('woocommerce_helper_suppress_connect_notice', '__return_true');
add_filter('rank_math/sitemap/remove_credit', '__return_true');
add_filter('autoptimize_filter_main_imgopt_plug_notice', '__return_empty_string');
