<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

// @see https://wpti.ps/remove-meta-generator-wordpress-woocommerce-revslider-wpbakery/

remove_action('wp_head', 'wp_generator');
add_filter('the_generator', '__return_empty_string');

// remove revslider meta generator tag
add_filter('revslider_meta_generator', '__return_empty_string');

// remove wpbakery visual_composer meta generator tag
add_action('wp_head', 'wpboys_remove_vc_metadata', 1);

function wpboys_remove_vc_metadata()
{
    if (class_exists('Vc_Manager')) {
        remove_action('wp_head', array(visual_composer(), 'addMetaData'));
    }
}

// remove wpml meta generator tag
if (! empty($GLOBALS['sitepress'])) {
    function wpboys_remove_wpml_generator()
    {
        remove_action(current_filter(), array($GLOBALS['sitepress'], 'meta_generator_tag'));
    }

    add_action('wp_head', 'wpboys_remove_wpml_generator', 0);
}

//Remove generator tags from Feed
remove_action('rss2_head', 'the_generator');
remove_action('rss_head', 'the_generator');
remove_action('rdf_header', 'the_generator');
remove_action('atom_head', 'the_generator');
remove_action('commentsrss2_head', 'the_generator');
remove_action('opml_head', 'the_generator');
remove_action('app_head', 'the_generator');
remove_action('comments_atom_head', 'the_generator');

/*
 * Hook into the WPML generator.
 */
if (! empty($GLOBALS['sitepress'])) {
    function remove_wpml_generator()
    {
        remove_action(current_filter(), array($GLOBALS['sitepress'], 'meta_generator_tag'));
    }

    add_action('wp_head', 'remove_wpml_generator', 0);
}

/**
 * Hook into the Slider Revolution generator.
 */
function remove_revslider_meta_tag()
{
    return '';
}

add_filter('revslider_meta_generator', 'remove_revslider_meta_tag');

/*
 * Hook into the WPBakery Page Builder generator.
 */
add_action('init', 'wpbakery_page_builder_generator_remover_fn', 100);
function wpbakery_page_builder_generator_remover_fn()
{
    if (class_exists('Vc_Manager') || class_exists('Vc_Base')) {
        remove_action('wp_head', array(visual_composer(), 'addMetaData'));
    }
}

/*
 * Hook into the Easy Digital Downloads generator.
 */
add_action('wp_head', 'remove_edd_version_in_header_action', 8);
function remove_edd_version_in_header_action()
{
    remove_action('wp_head', 'edd_version_in_header');
}

/*
 * Hook into the Master Slider generator.
 */
if (! function_exists('msp_remove_class_filter')) {
    function msp_remove_class_filter($tag, $class_name = '', $method_name = '', $priority = 10)
    {
        global $wp_filter;
        // Check that filter actually exists first
        if (! isset($wp_filter[$tag])) {
            return false;
        }
        if (is_object($wp_filter[$tag]) && isset($wp_filter[$tag]->callbacks)) {
            // Create $fob object from filter tag, to use below
            $fob       = $wp_filter[$tag];
            $callbacks = &$wp_filter[$tag]->callbacks;
        } else {
            $callbacks = &$wp_filter[$tag];
        }
        // Exit if there aren't any callbacks for specified priority
        if (! isset($callbacks[$priority]) || empty($callbacks[$priority])) {
            return false;
        }
        // Loop through each filter for the specified priority, looking for our class & method
        foreach ((array) $callbacks[$priority] as $filter_id => $filter) {
            // Filter should always be an array - array( $this, 'method' ), if not goto next
            if (! isset($filter['function']) || ! is_array($filter['function'])) {
                continue;
            }
            // If first value in array is not an object, it can't be a class
            if (! is_object($filter['function'][0])) {
                continue;
            }
            // Method doesn't match the one we're looking for, goto next
            if ($filter['function'][1] !== $method_name) {
                continue;
            }
            // Method matched, now let's check the Class
            if (get_class($filter['function'][0]) === $class_name) {
                // WordPress 4.7+ use core remove_filter() since we found the class object
                if (isset($fob)) {
                    // Handles removing filter, reseting callback priority keys mid-iteration, etc.
                    $fob->remove_filter($tag, $filter['function'], $priority);
                } else {
                    // Use legacy removal process (pre 4.7)
                    unset($callbacks[$priority][$filter_id]);
                    // and if it was the only filter in that priority, unset that priority
                    if (empty($callbacks[$priority])) {
                        unset($callbacks[$priority]);
                    }
                    // and if the only filter for that tag, set the tag to an empty array
                    if (empty($callbacks)) {
                        $callbacks = array();
                    }
                    // Remove this filter from merged_filters, which specifies if filters have been sorted
                    unset($GLOBALS['merged_filters'][$tag]);
                }

                return true;
            }
        }

        return false;
    }
}
add_action('plugins_loaded', function () {
    msp_remove_class_filter('wp_head', 'MSP_Frontend_Assets', 'meta_generator');
});

/*
 * Hook into the LayerSlider generator.
 */
add_filter('ls_meta_generator', function () {
    return '';
});

/*
 * Hook into the Site Kit by Google generator.
 */
add_action('get_header', function () {
    ob_start(function ($o) {
        return preg_replace('/\n?<.*?content="Site Kit by Google.*?>/mi', '', $o);
    });
});
add_action('wp_head', function () {
    ob_end_flush();
}, 992);

/*
 * Hook into the Divi theme meta generator.
 */
add_action('get_header', function () {
    ob_start(function ($o) {
        return preg_replace('/\n?<.*?content="Divi v.*?>/mi', '', $o);
    });
});
add_action('wp_head', function () {
    ob_end_flush();
}, 990);

/**
 * Hook into the Yoast SEO comments.
 */
function remove_yoast_seo_comments_fn()
{
    if (! class_exists('WPSEO_Frontend')) {
        return;
    }
    $instance = WPSEO_Frontend::get_instance();
    // To ensure that future version of the plugin does not cause any problem
    if (! method_exists($instance, 'debug_mark')) {
        return;
    }
    remove_action('wpseo_head', array($instance, 'debug_mark'), 2);
}

add_action('template_redirect', 'remove_yoast_seo_comments_fn', 9999);
function debug_marker_set_false()
{
    return false;
}

add_filter('wpseo_debug_markers', 'debug_marker_set_false');

/*
 * Hook into the WP Rocket comments.
 */
define('WP_ROCKET_WHITE_LABEL_FOOTPRINT', true);

/**
 * Hook into the Google Analytics (MonsterInsights) comments.
 */
function rgamc_active($plugin)
{
    $network_active = false;
    if (is_multisite()) {
        $plugins = get_site_option('active_sitewide_plugins');
        if (isset($plugins[$plugin])) {
            $network_active = true;
        }
    }

    return in_array($plugin, get_option('active_plugins')) || $network_active;
}

if (rgamc_active('google-analytics-for-wordpress/googleanalytics.php') || rgamc_active('google-analytics-premium/googleanalytics.php')) {
    add_action('get_header', function () {
        ob_start(function ($o) {
            return preg_replace('/\n?<.*?monsterinsights .*?>/mi', '', $o);
        });
    });
    add_action('wp_head', function () {
        ob_end_flush();
    }, 999);
}

/**
 * remove wp version param from any enqueued scripts (using wp_enqueue_script()) or styles (using wp_enqueue_style()).
 * But first check the list of user defined excluded CSS/JS files... Those files will be skipped and version information
 * will be kept.
 */
function pkm_remove_appended_version_script_style($target_url)
{
    $filename_arr = explode('?', basename($target_url));
    $filename     = $filename_arr[0];
    global $exclude_files_arr, $exclude_file_list;
    $data_to_pass = $exclude_files_arr;
    if (null === $data_to_pass) {
        $data_to_pass = array();
    }
    // first check the list of user defined excluded CSS/JS files
    if (! in_array(trim($filename), $data_to_pass)) {
        /* check if "ver=" argument exists in the url or not */
        if (strpos($target_url, 'ver=')) {
            $target_url = remove_query_arg('ver', $target_url);
        }
        /* check if "version=" argument exists in the url or not */
        if (strpos($target_url, 'version=')) {
            $target_url = remove_query_arg('version', $target_url);
        }
    }

    return $target_url;
}

/*
 * Priority set to 20000. Higher numbers correspond with later execution.
 * Hook into the style loader and remove the version information.
 */
add_filter('style_loader_src', 'pkm_remove_appended_version_script_style', 20000);

/*
 * Hook into the script loader and remove the version information.
 */
add_filter('script_loader_src', 'pkm_remove_appended_version_script_style', 20000);
