<?php
/**
 * @wordpress-plugin
 * Plugin Name:       mywpguru
 * Plugin URI:        https://mywp.guru
 * Description:       Connector for the myWP.guru Service.
 * Version:           is fully automatically updated to the latest
 * Author:            Phil Taylor
 * Author URI:        mywp.guru
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       https://mywp.guru
 * Domain Path:       /languages
 *
 * @copyright Copyright (C) 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see      https://mySites.guru/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 */

// If this file is called directly, abort.
if (!defined('WPINC')) {
    exit;
}

register_activation_hook(__FILE__, 'mywpguru_activate');
function mywpguru_activate()
{
    $parts = explode(DIRECTORY_SEPARATOR, plugin_basename(__FILE__));

    // if DIRECTORY_SEPARATOR is \ and WP is returning / in the plugin_basename - fml.
    if (preg_match('/\//', $parts[0])) {
        $parts = explode('/', plugin_basename(__FILE__));
    }

    if ('mywpguru' !== $parts[0]) {
        add_action('admin_notices', 'mywpguru_folder_error_notice');
        rename(__DIR__, dirname(__DIR__).DIRECTORY_SEPARATOR.'mywpguru');
        wp_die('<h1>WAIT! There is another step!</h1><p>Sorry about this, Wordpress installed our plugin into a folder with a "-1" suffix, we have renamed the folder for you now</p><p>Please click <a href="'.admin_url('plugins.php?s=mywpguru&plugin_status=all').'">HERE to load the Plugins Page</a>, and then click ACTIVATE again to activate the plugin.</p>');
    } else {
        set_transient('mywpguru-admin-notice', true, 5);
    }
}

add_action('admin_notices', 'mywpguru_admin_notice');
function mywpguru_admin_notice()
{
    if (get_transient('mywpguru-admin-notice')) {
        ?>
        <div class="updated notice is-dismissible">

            <h1>Excellent, the myWP.guru plugin is activated</h1>
            <p>Please now return to our site and complete the connection process, if you have any connection errors, READ them carefully, and if you still need help use the <a href="https://mysites.guru/contact">Contact Us</a> pages in our service</p>
        </div>
        <?php
        delete_transient('mywpguru-admin-notice');
    }
}

require 'bfnetwork/bfPlugin.php';
